<?php
namespace App\Controllers;
use App\Models\DiscountTypeModel;
use App\Models\UserModel;
use App\Controllers\BaseController;

class DiscountTypeController extends BaseController
{    
    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->discountTypeModel = new DiscountTypeModel();
        $this->now = date("Y-m-d H:i:s");
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
    } 
    // insert data
    public function register() 
    {
        $user_info = getUserInfo();
        $validation = $this->validate([
            'discount_type' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Discount Type is required',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        $session = session();
        if($validation){   
            if($id == ''){  //insert discount type details      
                $data = [
                    'discount_type' => $this->request->getVar('discount_type'),
                    'delete_flag' => '0',
                    'created_at'=>date('Y-m-d H:i:s'),
                    'created_by'=>$user_info->UserID,
                ];
                //set trans status
                $transaction_status = false;
                //---begin transaction---
                $this->db->transBegin();
                $this->discountTypeModel->insertData($data);
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                       // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                   // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Discount type  details saved successfully.'); 
                }           
            }
            else{      //update discount type details
                $data = [
                    'discount_type' => $this->request->getVar('discount_type'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'updated_by' =>$user_info->UserID,
                ];        
                $this->discountTypeModel->updateData($id, $data);
                    // Set the success flash message
          $session->setFlashdata('title', 'Saved');
          $session->setFlashdata('message', ' Discount type  details updated successfully.');
            }
             return $this->response->redirect(site_url('/discount_type'));
                 }
        else{
            $user_info = getUserInfo();
            $records['Discount_type']=$this->discountTypeModel->getIndexDiscountData();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Discount_type',
                'link' => 'discount_type',
                'sources' => $records,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,
            );
            return view('discount_type', $data);
        }
    }
    //get single data
    public function singleData($id = null) 
    {
        $data=$this->discountTypeModel->getSingleDiscData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    public function index()
    {
        $user_info = getUserInfo();
        $records['Discount_type']=$this->discountTypeModel->getIndexDiscountData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Discount_type',
            'link' => 'discount_type',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('discount_type', $data);
    }
    // delete
    public function delete($id = null)
    {
        $user_info = getUserInfo();
        $data = [
            'deleted_at' =>  $this->now,
            'delete_flag' => '1',
            'deleted_by' => $user_info->UserID,
        ];
        $this->discountTypeModel->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/discount_type'));
    } 
     // Payment Type disable
     public function disablediscounttype($id = null)
     {
         $data = [
             'current_status' => '2'
         ];
         if($this->discountTypeModel->statusupdate($id, $data)):                
             echo json_encode(array('status'=>true));
         endif;
     }
     // Payment Type enable
     public function enablediscounttype($id = null)
     {
         $data = [
             'current_status' => '1'
         ];
         if($this->discountTypeModel->statusupdate($id, $data)):                
             echo json_encode(array('status'=>true));
         endif;
     }
}
