<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\FunctionalityModel;
use App\Models\UserPermissionModel;
use App\Controllers\BaseController;
use App\Models\CommonModel;

class FunctionalityController extends BaseController
{

     //construct function
     public function __construct()
     {
        $this->functionalityModel = new FunctionalityModel();
        $this->UserPermissionModel = new UserPermissionModel();
        $this->common = new CommonModel(); 
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
    }

     // insert data
    public function insert() 
    {
        $user_info = getUserInfo();   
        $validation = $this->validate([
            'FName' => [
                'rules'=>'required|is_unique[functionalities.FName,FID,{FID}]',
                'errors'=>[
                    'required'=>'Please enter value',
                    'is_unique'=>'This Functionality Name  exists!',
                   
                ],
            ],
        ]);

        $fID = $this->request->getVar('FID');
        $session = session();
        if($validation){
            if($fID == ''){  //insert functionality details
                $data = [
                    'FName' => $this->request->getVar('FName'),
                    'FCreatedAt' => date('Y-m-d H:i:s'),
                    'FCreatedBy' =>  $user_info->UserID,
                    'delete_flag' => '0',
                ];
                      //set trans status
                      $transaction_status = false;
                      //---begin transaction---
                      $this->db->transBegin();

                $this->functionalityModel->insertFunData($data);

                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                       // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                   // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Functionality details  details saved successfully.'); 
                }         


            }
                else { //update functionality details
                 $data = [
                    'FName' => $this->request->getVar('FName'),
                    'FUpdatedAt' => date('Y-m-d H:i:s'),
                    'FUpdatedBy' =>  $user_info->UserID,
                    ];    
                $this->functionalityModel->update($fID, $data);
                $updated_fname=$this->request->getVar('FName');
                $this->UserPermissionModel->updateFname($fID, $updated_fname);
                
                    // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('message', 'Functionality details updated successfully.');
                }
            return $this->response->redirect(site_url('/functionality'));

        }
        else{
            $user_info = getUserInfo();
            $functionalities['Functionalities'] =  $this->functionalityModel->where('delete_flag', '0')->orderBy('FID', 'ASC')->findAll();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Functionality',
                'link' => 'functionality',
                'functionalities' => $functionalities,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                    );
                    return view('/functionality', $data);
         }       
    }

    public function index()
    {
        $user_info = getUserInfo();  
        $functionalities['Functionalities'] =  $this->functionalityModel->where('delete_flag', '0')->orderBy('FID', 'ASC')->findAll();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Functionality',
            'link' => 'functionality',
            'functionalities' => $functionalities,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('functionality', $data);
    }
    
    //get single data
    public function singleData($id = null)
     {
        $data =  $this->functionalityModel->where('FID', $id)->first();
       
        if($data){
            echo json_encode(array("status" => true, 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete
    public function delete($id = null)
    {
        $now = date("Y-m-d H:i:s");
        $user_info = getUserInfo(); 
        // $has_rulebook_info = $this->common->checkForeignKeyConstraints("rulebook"," FID",$id,"delete_flag",0);
        $has_userpermissiondetail_info = $this->common->checkForeignKeyConstraints("userpermissiondetail","functionalityID",$id,"UserPermissionDetailStatus",1);
        $msg_prefix = 'This functionality has ';
        $msg_userpermissiondetail_info = 'userpermission information';
        $data = [
            'FDeletedAt' => $now,
            'delete_flag' => '1',
            'FDeletedBy' => $user_info->UserID,
        ];
        if($has_userpermissiondetail_info){
            $msg = $msg_prefix.$msg_userpermissiondetail_info;
        }
        if($has_userpermissiondetail_info ){
            return $this->response->setJSON([
                'error' => true,
                'message' => $msg
            ]);
        }
        else{
            $this->functionalityModel->update($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }

        // $this->functionalityModel->update($id, $data);
        // return $this->response->setJSON([
        //     'error' => false,
        //     'message' => 'Successfully deleted!'
        // ]);
    } 

       // functionality disable
       public function disablefunctionality($id = null)
       {
           $data = [
               'current_status' => '2'
           ];    
           
           if($this->functionalityModel->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
       // functionality enable
       public function enablefunctionality($id = null)
       {
           $data = [
               'current_status' => '1'
           ];
           if($this->functionalityModel->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
}
