<?php

namespace App\Controllers;
use App\Controllers\BaseController;;
use App\Models\PaymentTypeModel;
use App\Models\UserModel;

class PaymentTypesController extends BaseController
{
        //construct function
        public function __construct()
        {
            $this->payement_type = new PaymentTypeModel();   
            $this->db = \Config\Database::connect();

            helper(['url','form','app']);
        }
        //insert/update data
        public function submit() 
        {
            $user_info = getUserInfo(); 
            $validation = $this->validate([
            
                'payment_type' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter a value',
                    ],
                ],
            ]);
            $id = $this->request->getVar('id');
            $session = session();
            if($validation){
                if($id == ''){  
                    //insert
                    $data = [
                        'payment_type_name'  => $this->request->getVar('payment_type'),
                        'created_at' => date('Y-m-d H:i:s'),
                        'created_by' =>  $user_info->UserID,
                    ];
                        //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();
                    $this->payement_type->insertData($data);

                    // Set the success flash message
                if ($this->db->transStatus() === FALSE){
                        //---rollback transaction
                        $this->db->transRollback();
                        $transaction_status = false;
                        // Set the success flash message
                        $session->setFlashdata('title', 'Error');
                        $session->setFlashdata('icon', 'warning');
                        $session->setFlashdata('message', 'Something Went wrong.');  
                    }
                    else{
                        //---commit transaction
                        $this->db->transCommit();
                        $transaction_status = true;
                    // Set the success flash message
                        $session->setFlashdata('title', 'Saved');
                        $session->setFlashdata('icon', 'success');
                        $session->setFlashdata('message', 'Payment Type  details saved successfully.'); 
                    }           
                }
                else{   
                    //update
                    $data = [
                        'payment_type_name'  => $this->request->getVar('payment_type'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'updated_by' =>  $user_info->UserID,
                    ];
                    $this->payement_type->updateData($id, $data);
                    // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('message', 'Payment Type details updated successfully.');
                }
                return $this->response->redirect(site_url('/payment_types'));
            }
            else{
                $user_info = getUserInfo();
                $records['payement_types'] = $this->payement_type->index();
                $has_errors = 'true';
                $data = array(
                    'breadcrumbs' => 'true',
                    'title' => 'Payment_Types',
                    'link' => 'payment_types',
                    'sources' => $records,
                    'userinfo' => $user_info,
                    'has_errors' => $has_errors,
                    'validation'=>$this->validator,
                );
                return view('payment_types', $data);
                
            }
        }
        //get specific data
        public function singleData($id = null)
        {
            $data= $this->payement_type->getSpecificData($id);
            if($data){
                echo json_encode(array("status" => true , 'data' => $data));
            }else{
                echo json_encode(array("status" => false));
            }
        }
        //get all data
        public function index()
        {
            $user_info = getUserInfo();
            $records['payement_types'] = $this->payement_type->index();
            $has_errors = 'false';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Payment_Types',
                'link' => 'payment_types',
                'sources' => $records,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
            );
            return view('payment_types', $data);
        }
        // delete data
        public function delete($id = null)
        {
            $now = date("Y-m-d H:i:s");
            $data = [
                'deleted_at' => $now,
                'delete_flag' => 1,
            ];
            $this->payement_type->deleteData($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        } 
       // Payment Type disable
       public function disablepaymenttypes($id = null)
       {
           $data = [
               'current_status' => '2'
           ];
           if($this->payement_type->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
       // Payment Type enable
       public function enablepaymenttypes($id = null)
       {
           $data = [
               'current_status' => '1'
           ];
           if($this->payement_type->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
}
