<?php

namespace App\Controllers;
use App\Models\UserRoleModel;
use App\Models\UserModel;
use App\Models\CommonModel;
use App\Models\ReceivingModel;
use App\Models\ReceivingDetailModel;
use App\Models\SellingPriceModel;
use App\Models\PurchasingPriceModel;
use App\Controllers\BaseController;
use App\Models\StocksModel;

class PriceManagementController extends BaseController
{
    public function __construct()
    {        
        $this->userroleModel = new UserRoleModel();
        $this->ReceivingModel = new ReceivingModel();
        $this->ReceivingDetailModel = new ReceivingDetailModel();
        $this->SellingPriceModel = new SellingPriceModel();
        $this->PurchasingPriceModel = new PurchasingPriceModel();
        $this->StocksModel = new StocksModel();
        $this->common = new CommonModel(); 
        helper(['url','form','app']);
    }
    
    // insert data
    public function savePriceDetails()
    {
          $user_info = getUserInfo();  
          $tableData = json_decode($this->request->getPost('tableData'), true); 
            foreach ($tableData as $subArray) {
                $type = $subArray['type'];
                $status = $subArray['status'];
                $data['item_id']= $subArray['item_id'];
                $data['item_name']= $subArray['item_name'];
                $data['batch_number']= $subArray['batch_number'];
                $data['comment']= $subArray['comment'];
                $data['created_at']=date('Y-m-d H:i:s');
                $data['created_by']=$user_info->UserID;
                $receiving_detail_id=$subArray['receiving_detail_id'];        
                if($type=='selling'){    
                    if($status=='1'){ //fetch the record which only changed the price value
                        $data['selling_price']= $subArray['price'];
                        $this->SellingPriceModel->insertData($data);
                        //get already having receiving detail data from receving detail table
                        $receving_data=$this->ReceivingDetailModel->getSingleRecDetailDataForSellingPrice($receiving_detail_id);
                        $item_id=$subArray['item_id'];
                        $batch_number=$subArray['batch_number'];
                        $updatedprice=$subArray['price'];
                        // update stock table
                        $this->StocksModel->updateSellingPrice( $item_id,$batch_number,$updatedprice);
                        foreach ($receving_data as $singleData) { //select all updated selling price records in receving detail table and update their RDSTatus=0
                            $receiving_detail_id= $singleData['RDID'];
                            $updateddata['RID']= $singleData['RID'];
                            $updateddata['ItemID']= $singleData['ItemID'];
                            $updateddata['RDIsSerialized']= $singleData['RDIsSerialized'];
                            $updateddata['RDLine']= $singleData['RDLine'];
                            $updateddata['RDQty']= $singleData['RDQty'];
                            $updateddata['RDUnit']= $singleData['RDUnit'];
                            $updateddata['RDCostPrice']= $singleData['RDCostPrice'];
                            $updateddata['RDSellingPrice']= $subArray['price'];;
                            $updateddata['RDMFD']= $singleData['RDMFD'];
                            $updateddata['RDEXP']= $singleData['RDEXP'];
                            $updateddata['RDiscount']= $singleData['RDiscount'];
                            $updateddata['RAmount']= $singleData['RAmount'];
                            $updateddata['RDUpdatedAt']=date('Y-m-d H:i:s');
                            $updateddata['RDUpdatedBy']=$user_info->UserID;
                            $updateddata['RDStatus']='0';
                       //update receving details
                        $this->ReceivingDetailModel->updateRecevingDetailData($receiving_detail_id, $updateddata);
                        // save changed records as new values to table
                            $newdata['RID']= $singleData['RID'];
                            $newdata['ItemID']= $singleData['ItemID'];
                            $newdata['RDIsSerialized']= $singleData['RDIsSerialized'];
                            $newdata['RDLine']= $singleData['RDLine'];
                            $newdata['RDQty']= $singleData['RDQty'];
                            $newdata['RDUnit']= $singleData['RDUnit'];
                            $newdata['RDCostPrice']= $singleData['RDCostPrice'];
                            $newdata['RDSellingPrice']= $subArray['price'];
                            $newdata['RDMFD']= $singleData['RDMFD'];
                            $newdata['RDEXP']= $singleData['RDEXP'];
                            $newdata['RDiscount']= $singleData['RDiscount'];
                            $newdata['RAmount']= $singleData['RAmount'];
                            $newdata['RDCreatedAt']=date('Y-m-d H:i:s');
                            $newdata['RDCreatedBy']=$user_info->UserID;
                            $newdata['RDStatus']='1';
                            // insert new record to receiving detial table
                        $this->ReceivingDetailModel->insertRecevingDetailData($newdata);

                     }
                    }
                    else{
                    }
                }
                else{
                    if($status=='1'){ //fetch the record which only changed the price value      
                        $data['purchasing_price']= $subArray['price'];
                        $this->PurchasingPriceModel->insertData($data);
                        //get already having receiving detail data from receving detail table
                        $receving_data=$this->ReceivingDetailModel->getSingleRecDetailDataForSellingPrice($receiving_detail_id);
                        $item_id=$subArray['item_id'];
                        $batch_number=$subArray['batch_number'];
                        $updatedprice=$subArray['price'];
                        foreach ($receving_data as $singleData) { //select all updated selling price records in receving detail table and update their RDSTatus=0
                            $receiving_detail_id= $singleData['RDID'];
                            $updateddata['RID']= $singleData['RID'];
                            $updateddata['ItemID']= $singleData['ItemID'];
                            $updateddata['RDIsSerialized']= $singleData['RDIsSerialized'];
                            $updateddata['RDLine']= $singleData['RDLine'];
                            $updateddata['RDQty']= $singleData['RDQty'];
                            $updateddata['RDUnit']= $singleData['RDUnit'];
                            $updateddata['RDSellingPrice']= $singleData['RDSellingPrice'];
                            $updateddata['RDCostPrice']= $subArray['price'];;
                            $updateddata['RDMFD']= $singleData['RDMFD'];
                            $updateddata['RDEXP']= $singleData['RDEXP'];
                            $updateddata['RDiscount']= $singleData['RDiscount'];
                            $updateddata['RAmount']= $singleData['RAmount'];
                            $updateddata['RDUpdatedAt']=date('Y-m-d H:i:s');
                            $updateddata['RDUpdatedBy']=$user_info->UserID;
                            $updateddata['RDStatus']='0';
                       //update receving details
                        $this->ReceivingDetailModel->updateRecevingDetailData($receiving_detail_id, $updateddata);
                        // save changed records as new values to table
                            $newdata['RID']= $singleData['RID'];
                            $newdata['ItemID']= $singleData['ItemID'];
                            $newdata['RDIsSerialized']= $singleData['RDIsSerialized'];
                            $newdata['RDLine']= $singleData['RDLine'];
                            $newdata['RDQty']= $singleData['RDQty'];
                            $newdata['RDUnit']= $singleData['RDUnit'];
                            $newdata['RDCostPrice']=$subArray['price']; 
                            $newdata['RDSellingPrice']= $singleData['RDSellingPrice'];
                            $newdata['RDMFD']= $singleData['RDMFD'];
                            $newdata['RDEXP']= $singleData['RDEXP'];
                            $newdata['RDiscount']= $singleData['RDiscount'];
                            $newdata['RAmount']= $singleData['RAmount'];
                            $newdata['RDCreatedAt']=date('Y-m-d H:i:s');
                            $newdata['RDCreatedBy']=$user_info->UserID;
                            $newdata['RDStatus']='1';
                        // insert new record to receiving detial table
                        $this->ReceivingDetailModel->insertRecevingDetailData($newdata);
                       
                     }
                    }
                    else{
                    }
                }              
            }         
          //Return a response (if required)
          return $this->response->setJSON(['success' => true]);
          return $this->response->redirect(site_url('/price_management'));
    }

    public function index()
    {
        $user_info = getUserInfo();
        
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Price  Management',
            'link' => 'pricemanagement',
            'userinfo' => $user_info,
        );
        return view('pricemanagement', $data);
    }
    //get price details
    public function getPriceDetails() 
    {   
        $records = $this->ReceivingDetailModel->getPriceDetails();
        // Return the records as JSON
        return $this->response->setJSON($records);
    }

    // delete
    public function delete($id = null)
    {
        $user_info = getUserInfo();   
        $has_user_info = $this->common->checkForeignKeyConstraints("user","UserRole",$id,"delete_flag",0);
        $has_rulebook_info = $this->common->checkForeignKeyConstraints("rulebook","RoleID",$id,"delete_flag",0);
        $now = date("Y-m-d H:i:s");
        $data = [
            'URDeletedAt' => $now,
            'URDeletedBy'=>$user_info->UserID,
            'delete_flag' => '1',
        ];

        if($has_user_info || $has_rulebook_info){
            return $this->response->setJSON([
                'error' => true,
                'message' => 'Can not delete, this record has related information'
            ]);
        }
        else{
            $this->userroleModel->deleteUrole($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }

        // $UserRoleModel->update($id, $data);
        // $this->userroleModel->deleteUrole($id, $data);
        // return $this->response->setJSON([
        //     'error' => false,
        //     'message' => 'Successfully deleted!'
        // ]);
        //return $this->response->redirect(site_url('/functionality'));
    }
}
