<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\SalesModel;
use App\Models\SaleItemsModel;
use App\Models\CommonModel;
use App\Models\StocksModel;
use App\Models\BanksModel;
use App\Models\ItemsModel;
use App\Models\PaymentModel;
use App\Models\ReceivingSerialDetailModal;
use App\Models\GiftCardModel;
use App\Models\CustomerLoyaltiesModel;
use Dompdf\Dompdf;
use DateTime;
use DateInterval;
use Config\Database;

class SalesController extends BaseController
{
    
    //construct function
    public function __construct()
    {
        $this->sale = new SalesModel();    
        $this->sale_item = new SaleItemsModel();    
        $this->common = new CommonModel();   
        $this->stocks = new StocksModel();  
        $this->serial_item = new ReceivingSerialDetailModal();
        $this->bank = new BanksModel();  
        $this->items = new ItemsModel();
        $this->payment = new PaymentModel();
        $this->gift_card = new GiftCardModel();
        $this->customer_loyalties = new CustomerLoyaltiesModel();
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
       
    }
    public function index()
    {      
        $user_info = getUserInfo();   
        $items = $this->items->getItemActiveIndexData();
        $has_errors = 'false';
        $banks = $this->bank->getAllActiveIndexNBankData();
        $loyalty_percentage = ($this->common->getSpecificColumnValueByGivenColumnName('masterconfig','id','loyalty_percentage',1,'delete_flag',0))->loyalty_percentage;
        $tax = ($this->common->getSpecificColumnValueByGivenColumnName('masterconfig','id','tax',1,'delete_flag',0))->tax;
        $data = array(
            'visa_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/visa.png'),
            'master_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/master.png'),
            'amex_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/amex.png'),
            'cash_cheque_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/cash_cheque.png'),
            'account_pay_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/account_pay.png'),
            'banks' => $banks,
            'loyalty_percentage' => $loyalty_percentage,
            'tax' => $tax,
            'breadcrumbs' => 'true',
            'title' => 'Sales',
            'link' => 'sales',
            'sources' => $items,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('sales', $data);
    }
    //insert/update data
    public function submit() 
    {
        //get user info
        $user_info = getUserInfo();   
        //get request data
        $id = $this->request->getVar('id');
        $all_sale_item_data_arr = ($this->request->getVar('sale_item_data_arr'))[1];
        $serial_no_data = ($this->request->getVar('serial_no_data'));
        $payment_data_ar = ($this->request->getVar('payment_data_ar'));
        $voucher_data_ar = ($this->request->getVar('voucher_data_ar'));
        $loyalty_data_ar = ($this->request->getVar('loyalty_data_ar'));
        $loyalty_redeem_data_ar = ($this->request->getVar('loyalty_redeem_data_ar'));
        //set sale data
        $sale_data = [
            'pos_id'  => $all_sale_item_data_arr['pos_id'],
            'user_id'  => $all_sale_item_data_arr['user_id'],
            'customer_id'  => $all_sale_item_data_arr['customer_id'],
            'sale_type_id'  => $all_sale_item_data_arr['sale_type_id'],
            'total_amount'  => $all_sale_item_data_arr['total_amount'],
            'discount_amount'  => $all_sale_item_data_arr['total_item_wise_discount_amount'],
            'created_at' => date('Y-m-d H:i:s'),
        ];
        //set trans status
        $transaction_status = false;
        //---begin transaction---
        $this->db->transBegin();
        //---insert sale data---
        $sale_data_insert_query = $this->sale->insertData($sale_data);
        //---sale item data---
        if ($sale_data_insert_query == true) {
            //get sale id
            $last_inserted_sale_id = $this->sale->insertID();
            //set sale item data
            for($i=0;$i<count($all_sale_item_data_arr['item_id_arr']);$i++){
                $sale_item_data[$i] = [
                    'sale_id'  => $last_inserted_sale_id,
                    'item_id'  => $all_sale_item_data_arr['item_id_arr'][$i],
                    'batch_no'  => $all_sale_item_data_arr['batch_no_arr'][$i],
                    'price'  => $all_sale_item_data_arr['sale_price_value_arr'][$i],
                    'discount'  => $all_sale_item_data_arr['discount_arr'][$i],
                    'qty'  => $all_sale_item_data_arr['qty_arr'][$i],
                    'authorized_by'  => $all_sale_item_data_arr['authorized_by_arr'][$i],
                    'created_at' => date('Y-m-d H:i:s'),
                ];
                //insert sale item data
                $sale_item_insert_query = $this->sale_item->insertData($sale_item_data[$i]);
            }
        }
        //---serial number data---
        if ($sale_item_insert_query == true) {
            if($serial_no_data != null){
                //set serial item data
                for($i=0;$i<count($serial_no_data);$i++){
                    $item_id = explode('-',$serial_no_data[$i])[0];
                    $serial_number = explode('-',$serial_no_data[$i])[1];
                    $item_serialized_id = (int)($this->serial_item->getSpecificSerializedData($item_id,$serial_number)->id);
                    if($item_serialized_id){
                        $serial_item_data[$i] = [
                            'sale_id'  => $last_inserted_sale_id,
                            'warranty_period	'  => explode('-',$serial_no_data[$i])[2],
                            'is_available_in_stock'  => 2,
                            'updated_at' => date('Y-m-d H:i:s'),
                        ];
                        //update serial item data
                        $serial_item_data_update_query = $this->serial_item->updateData($item_serialized_id,$serial_item_data[$i]);
                    }
                }
            }
        }
        //---payment data---
        if ($sale_item_insert_query == true) {
            if($payment_data_ar != null){
                //set payment data
                for($i=0;$i<count($payment_data_ar);$i++){
                    $customer_id = $all_sale_item_data_arr['customer_id'];
                    $payment_type_id = explode(',',$payment_data_ar[$i])[0];
                    $amount = explode(',',$payment_data_ar[$i])[1];
                    $bank_id = explode(',',$payment_data_ar[$i])[2];
                    $cheque = explode(',',$payment_data_ar[$i])[3];
                    $card = substr((explode(',',$payment_data_ar[$i])[4]), -4);
                    $payment_method_id = explode(',',$payment_data_ar[$i])[5];
                    $card_expiration_date = explode(',',$payment_data_ar[$i])[6];
                    $voucher = explode(',',$payment_data_ar[$i])[7];
                    $loyality = explode(',',$payment_data_ar[$i])[8];
                    if($payment_type_id == 1)
                        $reference_number ='';
                    else if($payment_type_id == 2 || $payment_type_id == 3)    
                        $reference_number = $card;
                    else if($payment_type_id == 4)
                        $reference_number = $cheque;
                    else if($payment_type_id == 5)
                        $reference_number = $voucher;
                    else if($payment_type_id == 6)
                        $reference_number = $loyality;
                    $payment_data[$i] = [
                        'sale_id'  => $last_inserted_sale_id,
                        'customer_id'  => $customer_id,
                        'amount'  => $amount,
                        'payment_type_id'  => $payment_type_id,
                        'bank_id'  => $bank_id,
                        'payment_method_id'  => $payment_method_id,
                        'card_expiration_date'  => $card_expiration_date,
                        'reference_number'  => $reference_number,
                        'payment_authorized_by_id'  => $all_sale_item_data_arr['payment_authorized_by_id'],
                        'remarks'  => '',
                        'created_at' => date('Y-m-d H:i:s'),
                    ];
                    //insert payment data
                    $payment_data_insert_query = $this->payment->insertData($payment_data[$i]);
                }
            }
        }
        //---customer loyalties---
        if ($payment_data_insert_query == true) {
            if($loyalty_data_ar != null){
                //set customer loyalties data
                $loyalty_percentage = explode(',',$loyalty_data_ar[0])[0];
                $customer_id = explode(',',$loyalty_data_ar[0])[1];
                $loyalty_amount = explode(',',$loyalty_data_ar[0])[2];
                $is_cash = explode(',',$loyalty_data_ar[0])[3];
                $cash_amount = explode(',',$loyalty_data_ar[0])[4];
                $loyalty_auth_code = explode(',',$loyalty_data_ar[0])[5];
                $loyalty_point_validity_period = ($this->common->getSpecificColumnValueByGivenColumnName('masterconfig','id','loyalty_point_validity_period',1,'delete_flag',0))->loyalty_point_validity_period;
                if($is_cash == 0){
                    $amount = $loyalty_amount;
                }
                else{
                    $amount = $cash_amount;
                }
                if($loyalty_point_validity_period != 0){
                    $current_date = new DateTime();
                    $exp_date = $current_date->add(new DateInterval("P{$loyalty_point_validity_period}M"));
                    $loyalty_exp_date = $exp_date->format("Y-m-d"); 
                }
                else{
                    $loyalty_exp_date = null;
                }
                if($loyalty_percentage != 0){
                    if($is_cash == 0){
                        $loyalty_data = [
                            'customer_id' => $customer_id,
                            'sale_id' => $last_inserted_sale_id,
                            'loyalty_percentage' => $loyalty_percentage,
                            'amount' => $amount,
                            'exp_date' => $loyalty_exp_date,
                            'is_cash' => $is_cash,
                            'auth_code' => $loyalty_auth_code,
                            'created_at' => date('Y-m-d H:i:s'),
                            'created_by' =>  $user_info->UserID,
                        ];
                        //insert loyalty data
                        $loyalty_data_insert_query = $this->customer_loyalties->insertData($loyalty_data);
                    }
                    else{
                        $loyalty_point_data = [
                            'customer_id' => $customer_id,
                            'sale_id' => $last_inserted_sale_id,
                            'loyalty_percentage' => $loyalty_percentage,
                            'amount' => $loyalty_amount,
                            'exp_date' => $loyalty_exp_date,
                            'is_cash' => 0,
                            'auth_code' => $loyalty_auth_code,
                            'created_at' => date('Y-m-d H:i:s'),
                            'created_by' =>  $user_info->UserID,
                        ];
                        //insert loyalty point data
                        $loyalty_point_data_insert_query = $this->customer_loyalties->insertData($loyalty_point_data);
                        $loyalty_cash_data = [
                            'customer_id' => $customer_id,
                            'sale_id' => $last_inserted_sale_id,
                            'loyalty_percentage' => $loyalty_percentage,
                            'amount' => $cash_amount,
                            'exp_date' => $loyalty_exp_date,
                            'is_cash' => 1,
                            'auth_code' => $loyalty_auth_code,
                            'created_at' => date('Y-m-d H:i:s'),
                            'created_by' =>  $user_info->UserID,
                        ];
                        //insert loyalty cash data
                        $loyalty_cash_data_insert_query = $this->customer_loyalties->insertData($loyalty_cash_data);
                    }
                }
            }
        }
        //---customer redeem loyalties---
        if ($payment_data_insert_query == true) {
            if(count($loyalty_redeem_data_ar) > 1){
                //set customer redeem loyalty data
                $count = explode('-',$loyalty_redeem_data_ar[0])[0];
                $customer_loyalty_ids = explode('-',$loyalty_redeem_data_ar[0])[1];
                $customer_loyalty_amounts = explode('-',$loyalty_redeem_data_ar[0])[2];
                $loyalty_auth_code = explode(',',$loyalty_data_ar[0])[5];
                if($count > 1){
                    for($i=0;$i<$count;$i++){
                        $customer_loyalty_id[$i] = explode(',',$customer_loyalty_ids)[$i];
                        $customer_loyalty_amount[$i] = explode(',',$customer_loyalty_amounts)[$i];
                        $available_loyalty_amount[$i] = $this->customer_loyalties->getSpecificData($customer_loyalty_id[$i])->amount;
                        //set loyalty redeem data
                        $loyalty_redeem_data[$i] = [
                            'amount' => (int)$available_loyalty_amount[$i] - (int)$customer_loyalty_amount[$i],
                            'auth_code' => $loyalty_auth_code,
                            'is_redeemed' => 1,
                            'updated_at' => date('Y-m-d H:i:s'),
                            'updated_by' =>  $user_info->UserID,
                        ];
                        //update loyalty redeem data
                        $loyalty_redeem_data_update_query = $this->customer_loyalties->updateData($customer_loyalty_id[$i],$loyalty_redeem_data[$i]);
                    }
                }
                else{
                    $customer_loyalty_id = $customer_loyalty_ids;
                    $customer_loyalty_amount = $customer_loyalty_amounts;
                    $available_loyalty_amount = $this->customer_loyalties->getSpecificData($customer_loyalty_id)->amount;
                    //set loyalty redeem data
                    $loyalty_redeem_data = [
                        'amount' => (int)$available_loyalty_amount - (int)$customer_loyalty_amount,
                        'auth_code' => $loyalty_auth_code,
                        'is_redeemed' => 1,
                        'updated_at' => date('Y-m-d H:i:s'),
                        'updated_by' =>  $user_info->UserID,
                    ];
                    //update loyalty redeem data
                    $loyalty_redeem_data_update_query = $this->customer_loyalties->updateData($customer_loyalty_id,$loyalty_redeem_data);
                }
            }
        }
        //---gift card data---
        if ($payment_data_insert_query == true) {
            if($voucher_data_ar != null){
                for($i=0;$i<count($voucher_data_ar);$i++){
                    //get voucher id
                    $voucher_id[$i] = (int)($this->common->getSpecificColumnValueByGivenColumnName('gift_cards','serial_number','id',$voucher_data_ar[$i],'delete_flag',0))->id;
                    //set voucher data
                    $voucher_data[$i] = [
                        'is_used' => 1,
                        'updated_at' => date('Y-m-d H:i:s'),
                        'updated_by' =>  $user_info->UserID,
                    ];
                    //update voucher data
                    $voucher_data_update_query = $this->gift_card->updateData($voucher_id[$i],$voucher_data[$i]);
                }
            }
        }
        //---stock data---
        if ($payment_data_insert_query == true) {
            //update stock
            for($i=0;$i<count($all_sale_item_data_arr['item_id_arr']);$i++){
                $item_id = $all_sale_item_data_arr['item_id_arr'][$i];
                $batch_no = $all_sale_item_data_arr['batch_no_arr'][$i];
                $stock_id = (int)(($this->stocks->select('StockID')->where('ItemID',$item_id)->where('BatchNo',$batch_no)->get()->getRow())->StockID);
                $stock_qty = ($this->common->getSpecificColumnValueByGivenColumnName('stocks','StockID','Qty',$stock_id,'StockStatus',1))->Qty;
                $sale_qty = $all_sale_item_data_arr['qty_arr'][$i];
                $updated_qty =  ($stock_qty - $sale_qty);
                $stock_data[$i] = [
                    'Qty' => $updated_qty,
                    'StockUpdatedAt' => date('Y-m-d H:i:s'),
                ];
                //update stock data
                $stock_data_update_query = $this->stocks->updateData($stock_id, $stock_data[$i]);
            }
        }
        if ($this->db->transStatus() === FALSE){
            //---rollback transaction
            $this->db->transRollback();
            $transaction_status = false;
            $message_text = "Error Occured";
            $message = 0;
        }
        else{
            //---commit transaction
            $this->db->transCommit();
            $transaction_status = true;
            $message_text = "Sale Stored Successfully";
            $message = $last_inserted_sale_id;
        }
        return $this->response->setJSON([
            'error' => !($transaction_status),
            'message' => $message,
            'message_text' => $message_text,
            'transaction_status' => $transaction_status,
        ]);
    }
    public function getSpecificSaleData($sale_id)
    {  
        $dompdf = new Dompdf();
        $sale_item_data = $this->sale_item->getSpecificSaleData($sale_id);
        $sale_data = $this->sale->getSpecificData($sale_id);
        $sale_created_at = $sale_data->created_at;
        $pos_id = $sale_data->pos_id;
        $total_amount = $sale_data->total_amount;
        $discount_amount = $sale_data->discount_amount;
        $customer_name = ($this->common->getSpecificColumnValueByGivenColumnName('customers','id','first_name',($sale_data->customer_id),'delete_flag',0))->first_name;
        $employee_name = ($this->common->getSpecificColumnValueByGivenColumnName('employee','EmpID','EmpName',($sale_data->user_id),'delete_flag',0))->EmpName;
        $data = [
            'imageSrc'    => $this->imageToBase64(ROOTPATH . '/public/img/logo.png'),
            'sale_id'         => $sale_id,
            'customer_name'   => $customer_name,
            'employee_name'   => $employee_name,
            'sale_created_at' => $sale_created_at,
            'pos_id'          => $pos_id,
            'total_amount'    => $total_amount,
            'discount_amount' => $discount_amount,
            'sale_item_data'  => $sale_item_data,
        ];
        $html = view('sale_invoice_pdf', $data);
        $dompdf->loadHtml($html);
        $dompdf->render();
        $dompdf->stream('sale_invoice_'.$sale_id.'.pdf',array('Attachment'=>0));
    }
    private function imageToBase64($path) {
        $path = $path;
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        return $base64;
    }
   
}
