<?php

namespace App\Controllers;
use App\Models\UserRoleModel;
use App\Models\UserModel;
use App\Models\CommonModel;
use App\Models\StocksModel;
use App\Controllers\BaseController;

class StockManagementController extends BaseController
{
    public function __construct()
    {        
        $this->userroleModel = new UserRoleModel();
        $this->StocksModel = new StocksModel();
        $this->common = new CommonModel(); 
        helper(['url','form','app']);
    }
    
    // insert data
    public function insert()
    {
        $user_info = getUserInfo();   
        $validation = $this->validate([
            'URName' => [
                'rules'=>'required|is_unique[userrole.URName,URoleID,{URoleID}]',
                'errors'=>[
                    'required'=>'Uname is required',
                    'is_unique'=>'This User Role already exists!',
                ],
            ],
        ]);
        $uroleId = $this->request->getVar('URoleID');
        $session = session();
        if($validation){   
            if($uroleId == ''){  //insert userrole details      
                $data = [
                    'URName' => $this->request->getVar('URName'),
                    'delete_flag' => '0',
                    'URCreatedAt'=>date('Y-m-d H:i:s'),
                    'URCreatedBy'=>$user_info->UserID,
                ]; 
                $this->userroleModel->insertuRoleData($data);
                 // Set the success flash message
            $session->setFlashdata('title', 'Saved');
            $session->setFlashdata('message', 'Userrole details saved successfully.');
            }
            else{      //update userrole details
                $data = [
                    'URName' => $this->request->getVar('URName'),
                    'URUpdatedAt' => date('Y-m-d H:i:s'),
                    'URUpdatedBy'=>$user_info->UserID,
                ];        
                $this->userroleModel->updateUrole($uroleId, $data);
                 // Set the success flash message
            $session->setFlashdata('title', 'Saved');
            $session->setFlashdata('message', 'Userrole details updated successfully.');
            }
             return $this->response->redirect(site_url('/userroles'));
                 }
        else{
            $has_errors = 'true';
            $user_info = getUserInfo(); 
            $urs['UserRoles']= $this->userroleModel->getUrolesIndexData();
            $data = [
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                'breadcrumbs' => 'true',
                'title' => 'User Roles',
                'link' => 'userroles',
                'sources' => $urs,
                'userinfo' => $user_info
            ];
            return view('/userroles', $data); 
        }
    }

    public function index()
    {
        $user_info = getUserInfo();
        $stock['stock']= $this->StocksModel->getIndexData();
        // $has_errors = 'false';
        
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Stock Management ',
            'link' => 'stock',
            'sources' => $stock,
            'userinfo' => $user_info,
          
        );
        // echo '<pre>';
        // print_r($stock);
        //   die();
        return view('stock', $data);
    }
    //get single data
    public function singleData($id = null) 
    {        
        $data= $this->userroleModel->getSingleuRoleData($id);
        if($data){
            echo json_encode(array("status" => true, 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete
    public function delete($id = null)
    {
        $user_info = getUserInfo();   
        $has_qunatity_info = $this->StocksModel->getSingleStocQunatityData($id);
        $now = date("Y-m-d H:i:s");
        //define message
        $msg='';
        if(($has_qunatity_info->Qty)> 0){
            $msg = 'This stock has quantity';
        }
       
        $data = [
            'StockDeletedAt' => $now,
            'StockDeletedBy'=>$user_info->UserID,
            'StockStatus' => '0',
        ];

        if(($has_qunatity_info->Qty)> 0){
            return $this->response->setJSON([
                'error' => true,
                'message' => $msg
            ]);
        }
        else{
            $this->StocksModel->deleteData($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }
    }
}
