<?php

    namespace App\Controllers;
    use App\Models\SuppliersModel;
    use App\Models\UserModel;
    use Config\Services;
    use App\Models\CommonModel;
    use App\Models\PaymentTermModel;

    class SuppliersController extends BaseController
    {   
        
        public function __construct()
        {
            $this->supmodel = new SuppliersModel();
            $this->common = new CommonModel(); 
            $this->payement_term = new PaymentTermModel();   
            helper(['url','form','app']);
            $this->db = \Config\Database::connect();
            $this->validation = Services::validation();
        }

        public function index()
        {
            $sup['supData']=$this->supmodel->getIndexData();
            $payment_terms = $this->payement_term->getActiveData();
            $has_errors = 'false';
            $user_info = getUserInfo();
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Suppliers',
                'link' => 'suppliers',
                'sources' => $sup,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'payment_terms' => $payment_terms,
            );  
            return view('suppliers', $data);
           
        }

         //insert  new supplier
        public function save() 
        {
            $user_info = getUserInfo(); 
            $validation = $this->validate([
                'SupplierCompanyName' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter name',
                    ],
                ],
                // 'SupplierBRNo' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter BR number',
                //     ],
                // ],
                // 'SupplierName' => [
                //     'rules'=>[
                //         'required',
                //         'is_unique[suppliers.SupplierName,SupplierID,{SupplierID}]',
                //     ],
                //     'errors'=>[
                //         'required'=>'Please enter supplier name',
                //         'is_unique'=>'This Suppplier already exists!',
                //     ],
                // ],
                'payment_term' => [
                    'rules'=>[
                        'rules'=>'required',
                    ],
                    'errors'=>[
                        'required'=>'Please select payment term',
                    ],
                ],
                // 'SupplierNIC' => [
                //     'rules'=>[
                //         'rules'=>'required',
                //         'is_unique[suppliers.SupplierNIC,SupplierID,{SupplierID}]',
                //         'regex_match[/^[0-9]{9}[vVxX]$/]'
                //     ],
                //     'errors'=>[
                //         'required'=>'Please enter NIC numbber',
                //         'regex_match' => 'Not a valid NIC number.',
                //         'is_unique'=>'This NIC already exists!',
                //     ],
                // ],
                // 'SupplierCity' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter city name',
                //     ],
                // ],
                // 'SupplierProvince' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter province name',
                //     ],
                // ],
                // 'SupplierCountry' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter country name',
                //     ],
                // ],
                // 'SupplierContactNo' => [
                //     'rules'=>[
                //         'required',
                //         //'regex_match[/^[0-9]{10}$/]',
                //         'is_unique[suppliers.SupplierContactNo,SupplierID,{SupplierID}]',
                //     ],
                //     'errors'=>[
                //         'required'=>'Please enter contact number',
                //         //'regex_match' => 'Contact Number must be a valid 10-digit mobile number.',
                //         'is_unique'=>'This Contact No already exists!',
                //     ],
                // ],
                // 'SupplierEmail' => [
                //     'rules'=>[
                //         'required',
                //         'valid_email',
                //         'is_unique[suppliers.SupplierEmail,SupplierID,{SupplierID}]',
                //     ],
                //     'errors'=>[
                //         'required'=>'Please enter email address',
                //         'valid_email'=>'Please enter valid email',
                //         'is_unique'=>'This Email already exists!',
                //     ],
                // ],
                // 'SupplierDescription' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter discription',
                //     ],
                // ],
                // 'SupplierBankName' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter bank  name',
                //     ],
                // ],
                // 'SupplierBankACNo' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter bank number ',
                //     ],
                // ],

            ]);
            $suppId = $this->request->getVar('SupplierID');
            $session = session();
            if($validation)
            {
                if($suppId == '')
                {  //insert supplier details
                    $data = [
                        'SupplierCompanyName' => $this->request->getVar('SupplierCompanyName'),
                        'SupplierBRNo'=>$this->request->getVar('SupplierBRNo'),
                        'SupplierName' => $this->request->getVar('SupplierName'),
                        'SupplierNIC' => $this->request->getVar('SupplierNIC'),
                        'SupplierAddressLine1' =>$this->request->getVar('SupplierAddressLine1'), 
                        'SupplierAddresLine2' => $this->request->getVar('SupplierAddressLine2'),
                        'SupplierCity' => $this->request->getVar('SupplierCity'),
                        'SupplierProvince' =>$this->request->getVar('SupplierProvince'), 
                        'SupplierCountry' => $this->request->getVar('SupplierCountry'),
                        'SupplierContactNo' =>$this->request->getVar('SupplierContactNo'), 
                        'SupplierEmail' =>$this->request->getVar('SupplierEmail'), 
                        'payment_term' =>$this->request->getVar('payment_term'), 
                        'SupplierDescription' => $this->request->getVar('SupplierDescription'),
                        'SupplierBankName' => $this->request->getVar('SupplierBankName'),
                        'SupplierBankACNo' =>$this->request->getVar('SupplierBankACNo'), 
                        'SupplierCreatedAt' => date('Y-m-d H:i:s'),   
                        'SupplierCreatedBy' => $user_info->UserID,
                        'delete_flag'=>'0' ,       
                    ];
                    if(!empty($_FILES['SuppImg']['name'])){             
                        $imageFile = $this->request->getFile('SuppImg');
                        $imageFile->move('../public/uploads/supImg');
                        $imgDetail =$_FILES['SuppImg'];
                        $data['SupplierImg']= $imgDetail ['name'];        
                    }
                        //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();

                    $this->supmodel->insertSupData($data);
                    if ($this->db->transStatus() === FALSE){
                        //---rollback transaction
                        $this->db->transRollback();
                        $transaction_status = false;
                        // Set the success flash message
                        $session->setFlashdata('title', 'Error');
                        $session->setFlashdata('icon', 'warning');
                        $session->setFlashdata('message', 'Something Went wrong.');  
                    }
                    else{
                        //---commit transaction
                        $this->db->transCommit();
                        $transaction_status = true;
                    // Set the success flash message
                        $session->setFlashdata('title', 'Saved');
                        $session->setFlashdata('icon', 'success');
                        $session->setFlashdata('message', 'Supplier details  details saved successfully.'); 
                    }         
            }
            else
            {
                $data = [
                    'SupplierCompanyName' => $this->request->getVar('SupplierCompanyName'),
                    'SupplierBRNo'  => $this->request->getVar('SupplierBRNo'),
                    'SupplierName'  => $this->request->getVar('SupplierName'),
                    'SupplierNIC'  => $this->request->getVar('SupplierNIC'),
                    'SupplierAddressLine1'  => $this->request->getVar('SupplierAddressLine1'),
                    'SupplierAddresLine2' => $this->request->getVar('SupplierAddressLine2'),
                    'SupplierCity'  => $this->request->getVar('SupplierCity'),
                    'SupplierProvince'  => $this->request->getVar('SupplierProvince'),
                    'SupplierCountry'  => $this->request->getVar('SupplierCountry'),
                    'SupplierContactNo'  => $this->request->getVar('SupplierContactNo'),
                    'SupplierDescription'  => $this->request->getVar('SupplierDescription'),
                    'SupplierEmail' => $this->request->getVar('SupplierEmail'),
                    'payment_term' =>$this->request->getVar('payment_term'), 
                    'SupplierBankName' => $this->request->getVar('SupplierBankName'),
                    'SupplierBankACNo'  => $this->request->getVar('SupplierBankACNo'),
                    'SupplierUpdatedBy' => $user_info->UserID,
                    'SupplierUpdatedAt' => date('Y-m-d H:i:s'),
                ];
                if(!empty($_FILES['SuppImg']['name'])){          
                    $imageFile = $this->request->getFile('SuppImg');
                    $imageFile->move('../public/uploads/supImg');
                    $imgDetail =$_FILES['SuppImg'];
                    $data['SupplierImg']= $imgDetail ['name'];
                }
                        $this->supmodel->updateSup($suppId, $data);    
                        // Set the success flash message
                    $session->setFlashdata('title', 'Updated');
                    $session->setFlashdata('message', 'Supplier updated successfully.');             
            }
                $this->response->redirect(site_url('/suppliers'));
        }
            else
            {
                    $sup['supData']=$this->supmodel->getIndexData();
                    helper('app'); 
                    $user_info = getUserInfo();
                    $has_errors = 'true';
                    $payment_terms = $this->payement_term->index();
                    $data = array(
                        'breadcrumbs' => 'true',
                        'title' => 'Suppliers',
                        'link' => 'suppliers',
                        'sources' => $sup,
                        'userinfo' => $user_info,
                        'validation'=>$this->validator,
                        'has_errors' => $has_errors,  
                        'payment_terms' => $payment_terms,    
                    );       
                    return view('suppliers', $data);
            }
        }
        //get single data
        public function singleData($id = null) 
        { 
            $data=$this->supmodel->getSingleSupData($id);
            if($data){                
                echo json_encode(array("status" => true , 'data' => $data));
            }else{            
                echo json_encode(array("status" => false));
            }
        }
       // delete supplier
        public function delete($id = null)
        {
            $user_info = getUserInfo();  
            $has_receiving_info = $this->common->checkForeignKeyConstraints("receiving","SupplierID",$id,"RStatus",1); 
            $msg_prefix = 'This supplier has ';
           $msg_receiving_info = 'receiving information';
           $msg = $msg_prefix.$msg_receiving_info;
            $now = date("Y-m-d H:i:s");
            $data = [
                'SupplierDeletedAt' => $now,
                'SupplierDeletedBy' => $user_info->UserID,
                'delete_flag' => '1',
            ];
            if($has_receiving_info){
                return $this->response->setJSON([
                    'error' => true,
                    'message' => $msg,
                ]);
            }
            else{
                $this->supmodel->deleteSup($id, $data);
                return $this->response->setJSON([
                    'error' => false,
                    'message' => 'Successfully deleted!'
                ]);
            }
            // return $this->response->redirect(site_url('/suppliers'));
        }

        // supplier disable
        public function disablesupplier($id = null)
        {
            $data = [
                'current_status' => '2'
            ];
            if($this->supmodel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }
        // supplier enable
        public function enablesupplier($id = null)
        {
            $data = [
                'current_status' => '1'
            ];
            if($this->supmodel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }


    }
?>