<?php

namespace App\Controllers;

use App\Controllers\BaseController;

use App\Models\UserModel;
use App\Models\ItemsModel;
use App\Models\SuppliersModel;
use App\Models\TempReceivingModel;
use App\Models\ItemCategoryModel;
use App\Models\TempReceivingDetailModel;
use App\Models\ItemUnitsModel;
use App\Models\TempItemSerializedModel;
use App\Models\ReceivingModel;
use App\Models\ReceivingDetailModel;
use App\Models\ReceivingSerialDetailModal;
use App\Models\StocksModel;

class TempReceivingController extends BaseController
{
    private $TempReceivingModel = null;
    private $ItemCategoryModel = null;
    private $TempReceivingDetailModel = null;
    private $SuppliersModel = null;
    private $ItemsModel = null;
    private $ItemUnitsModel = null;
    private $TempItemSerializedModel = null;
    private $ReceivingModel = null;
    private $ReceivingDetailModel = null;
    private $ReceivingSerialDetailModal = null;
    private $StocksModel = null;
    private $now = null;

    public function __construct()
    {
        $this->TempReceivingModel = new TempReceivingModel();
        $this->ItemCategoryModel = new ItemCategoryModel();
        $this->TempReceivingDetailModel = new TempReceivingDetailModel();
        $this->SuppliersModel = new SuppliersModel();
        $this->ItemsModel = new ItemsModel();
        $this->TempItemSerializedModel = new TempItemSerializedModel();
        $this->ItemUnitsModel = new ItemUnitsModel();
        $this->ReceivingModel = new ReceivingModel();
        $this->ReceivingDetailModel = new ReceivingDetailModel();
        $this->ReceivingSerialDetailModal = new ReceivingSerialDetailModal();
        $this->StocksModel = new StocksModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
    }
    
    public function index()
    {
        $user_info = getUserInfo();   
        $items = $this->ItemsModel->getItemIndexData();
        $ItemCategories = $this->ItemCategoryModel->getAllCategories();
        $Suppliers = $this->SuppliersModel->getIndexData();
        $tempReceivings = $this->TempReceivingModel->getIndexData();
        $has_errors = 'false';

        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Temproary Receivings',
            'link' => 'receivingsTempList',
            'sources' => $items,
            'Suppliers'=>$Suppliers,
            'ItemCategories'=>$ItemCategories,
            'tempReceivings'=>$tempReceivings,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('receivingsTempList', $data);
    }

    // save temp record from orgin
    public function saveTempRecItem()
    {
        $formdata = $this->request->getPost('frmData');
        $tableData = $this->request->getPost('tableData');
        parse_str($formdata, $parseData);
        $timestamp = microtime(true);
        $uniqueNumber = str_replace('.', '', $timestamp);

        $Rec = [];
        $RecDetail = [];
        $RecStocks = [];
        $serialInputs = [];
        $RecSerialDetail = [];
        $BNo = $this->checkBatchNo();

        if($parseData){
            $Rec = [
                'CartID' => (string)$uniqueNumber,
                'SupplierID' => $parseData['supplier'],
                'RType'  => $parseData['recMode'],
                'UserID'  => $parseData['userId'],
                'RBatchNo' => '',
                'RComment'  =>$parseData['comments'],
                'RNet'  =>$parseData['subtot'],
                'RNetwithtax'  => $parseData['tot'],
                'RPaymentType'  => $parseData['payType'],
                'RCreatedAt' => $this->now,
                'RStatus'=>'1'
            ];
        }
        $Reclast_id = $this->TempReceivingModel->insertRecData($Rec);
        
        if($tableData){
            //var_dump($tableData);
            foreach($tableData as $tData){
                //var_dump($tData);
                $i = 0;
                $RecDetail = [
                    'CartID' => (string)$uniqueNumber,
                    'RID' => $Reclast_id,
                    'ItemID' => (int)$tData['itemid'],
                    'RDIsSerialized' => $tData['serialized'],
                    'RDLine' => $i,
                    'RDQty' => $tData['qty'],
                    'RDUnit' => $tData['unit'],
                    'RDCostPrice' => $tData['price'],
                    'RDSellingPrice' => $tData['sellprice'],
                    'RDMFD' => $tData['manDate'],
                    'RDEXP' => $tData['expDate'],
                    'RDiscount' => $tData['disc'],
                    'RAmount' => $tData['ramount'],
                    'RDCreatedAt' => $this->now
                ];
                $i++;

                $last_id= $this->TempReceivingDetailModel->saveData($RecDetail);
                           

                //var_dump($tData['serialData']);
                if($tData['serialData'] != '' && $tData['serialized'] == '1'){
                    $serialInputs = json_decode($tData['serialData'], true);
                    //var_dump($serialInputs);
                    foreach ($serialInputs as $serial){
                        //var_dump($serial);
                        $RecSerialDetail['CartID'] = (string)$uniqueNumber;
                        $RecSerialDetail['RDID'] = $last_id;
                        $RecSerialDetail['item_id'] = $tData['itemid'];
                        $RecSerialDetail['receiving_id'] = $Reclast_id;
                        $RecSerialDetail['serial_number'] = $serial['serialno'];
                        $RecSerialDetail['item_status'] = $serial['status'];
                        $RecSerialDetail['warranty_period'] = $serial['warrenty'];
                        $RecSerialDetail['is_available_in_stock'] = '1';
                        $RecSerialDetail['created_at'] = $this->now;
                        //var_dump($RecSerialDetail);
                        $finalInsert = $this->TempItemSerializedModel->insert($RecSerialDetail);
                    }                    
                }
            }
        }
        return $this->response->setJSON([
            'error'=>false,
            'title' => 'Success',
            'text' => 'Receiving Stored Temproarly',
            'icon' => 'success'
        ]);
        // $timestamp = microtime(true);
        // $uniqueNumber = str_replace('.', '', $timestamp);
        // if($this->request->getMethod() == 'post') {
        //     $formdata = $this->request->getPost('frmData');
        //     // receiving table data
        //     $tableData = $this->request->getPost('tableData');
        //     //var_dump($tableData);

        //     if($formdata){
        //         parse_str($formdata, $parseData);
        //         $formdata = [
        //             'CartID' => (string)$uniqueNumber,
        //             'SupplierID' => $parseData['supplier'],
        //             'RType'  => $parseData['recMode'],
        //             'UserID'  => $parseData['userId'],
        //             'RBatchNo' => '',
        //             'RComment'  =>$parseData['comments'],
        //             'RNet'  =>$parseData['subtot'],
        //             'RNetwithtax'  => $parseData['tot'],
        //             'RPaymentType'  => $parseData['payType'],
        //             'RCreatedAt' => $this->now,
        //             'RStatus'=>'1',
        //         ];
        //     }
        // }
        // //insert receiving data to receving table
        // $Reclast_id = $this->TempReceivingModel->insertRecData($formdata);
        // if($tableData){         
        //     //var_dump($formdata);       
        //     if($Reclast_id){
        //         //var_dump($tableData);                   
        //         $i=0;
        //         if (!empty($tableData) && is_array($tableData)) {
        //             foreach ($tableData as $item) { 
        //                 //var_dump($item);                   
        //                 $finalTabledata[] = [         
        //                     'CartID' => (string)$uniqueNumber,                  
        //                     'RID'=>$Reclast_id,
        //                     'ItemID' => $item['id'],
        //                     'RDIsSerialized'=>$item['serialized'],
        //                     'RDLine'=>$i,
        //                     'RDQty' => $item['qty'],
        //                     'RDUnit' => $item['unit'],
        //                     'RDCostPrice'=>$item['price'],
        //                     'RDSellingPrice'=>$item['sellprice'],
        //                     'RDMFD'=>$item['manDate'],
        //                     'RDEXP'=>$item['expDate'],
        //                     'RDiscount'=>$item['disc'],
        //                     'RAmount'=>$item['ramount'],
        //                     'RDCreatedAt'=>$this->now
        //                 ];
        //                 $i++;
        //             }

        //             //var_dump($finalTabledata);
        //             //var_dump($tableData); 
        //             for($i = 0; $i < Count($finalTabledata); $i++){
        //                 // save receving details to receving detail table
        //                 $last_id= $this->TempReceivingDetailModel->saveData($finalTabledata[$i]);
                            
        //                 $finalSerials = [];
        //                 //var_dump($tableData);
                        
        //                 //foreach ($tableData as $item) { 
        //                     //if($item['serialized'] == '1'){                                 
        //                         if($item['serialData']){
        //                             var_dump($item['serialData']);
        //                             $serials = json_decode($item['serialData'], true);
        //                             //var_dump($serials);
                                    
        //                             foreach ($serials as $serial){
        //                                 //var_dump($Reclast_id);
        //                                 $finalSerials['CartID'] = (string)$uniqueNumber;
        //                                 $finalSerials['RDID'] = $last_id;
        //                                 $finalSerials['item_id'] = $item['id'];
        //                                 $finalSerials['receiving_id'] = $Reclast_id;
        //                                 $finalSerials['serial_number'] = $serial['serialno'];
        //                                 $finalSerials['item_status'] = $serial['status'];
        //                                 $finalSerials['warranty_period'] = $serial['warrenty'];
        //                                 $finalSerials['is_available_in_stock'] = '1';
        //                                 //$finalSerials['created_at'] = $this->now;
        //                                 var_dump($finalSerials);
        //                                 //$finalInsert = $this->TempItemSerializedModel->insertSerialData($finalSerials);
        //                                 //$finalInsert = $this->TempItemSerializedModel->insert($finalSerials);
                                        
        //                                 // if($finalInsert){
        //                                 //     echo json_encode(array('status' => true, 'message' => 'Serial Data Insrted Successfully'));
        //                                 // }else{
        //                                 //     echo json_encode(array("status" => false));
        //                                 // }
        //                             }
        //                         }
        //                     //}
        //                 //}
        //             }
        //         }
        //     }
        //     return $this->response->setJSON([
        //         'error'=>false,
        //         'title'=>'Successfully Saved!',
        //         'message'=>'Receiving Saved Temproary!'
        //     ]);
        // }
    }

    // Update temp reccord
    public function updateTemp()
    {
        $formdata = $this->request->getPost('frmData');
        $tableData = $this->request->getPost('tableData');
        parse_str($formdata, $parseData);
        // var_dump($formdata);
        //var_dump($tableData);
        // var_dump($parseData);
        $Rec = [];
        $RecDetail = [];
        $RecSerialDetail = [];
        if($parseData){
            $Rec = [
                'SupplierID' => $parseData['supplier'],
                'RType'  => $parseData['recMode'],
                'UserID'  => $parseData['userId'],
                'RBatchNo' => '',
                'RComment'  =>$parseData['comments'],
                'RNet'  =>$parseData['subtot'],
                'RNetwithtax'  => $parseData['tot'],
                'RPaymentType'  => $parseData['payType'],
                'RUpdatedAt' => $this->now
            ];
        }
        $this->TempReceivingModel->updateTempRec($parseData['RecCartID'], $Rec);
        if($tableData){
            foreach($tableData as $tData){
                //var_dump($tData);
                $i = 0;
                $RecDetail[] = [
                    'CartID'=>$parseData['RecCartID'],
                    'RID'=>'',
                    'ItemID' => $tData['id'],
                    'RDIsSerialized'=>$tData['serialized'],
                    'RDLine'=>$i,
                    'RDQty' => $tData['qty'],
                    'RDUnit' => $tData['unit'],
                    'RDCostPrice'=>$tData['price'],
                    'RDSellingPrice'=>$tData['sellprice'],
                    'RDMFD'=>$tData['manDate'],
                    'RDEXP'=>$tData['expDate'],
                    'RDiscount'=>$tData['disc'],
                    'RAmount'=>$tData['ramount'],
                    'RDUpdatedAt'=>$this->now
                ];
                $i++;
            }
            $deletePastRDetail = $this->TempReceivingDetailModel->deletePreviousRecord($parseData['RecCartID']);           
            
            if($deletePastRDetail){
                for($j = 0; $j < count($RecDetail); $j++){
                    $this->TempReceivingDetailModel->insert($RecDetail[$j]);
                }
            }
            //var_dump($RecDetail);
            foreach($tableData as $tData){
                if($tData['serialized'] == '1'){
                    var_dump($tData);
                    var_dump($tData['serialData']);
                    if($tData['serialData'] != ''){
                        $reolacedData = str_replace("'", '"', $tData['serialData']);
                        $serials = json_decode($reolacedData, true);
                        //$deletePastRSDetail = $this->TempItemSerializedModel->deletePreviousSerialRecord($parseData['RecCartID']);                                   
                            
                        foreach($serials as $serial){
                            //var_dump($serials);
                            //var_dump($serial);
                            $RecSerialDetail = [
                                'CartID' => $parseData['RecCartID'],
                                'RDID' => '',
                                'item_id' => $tData['id'],
                                'receiving_id' => '',
                                'serial_number' => $serial['serial_number'],
                                'item_status' => $serial['item_status'],
                                'warranty_period' => $serial['warranty_period'],
                                'is_available_in_stock' => '1',
                                'updated_at' => $this->now
                            ];
                            var_dump($RecSerialDetail);
            
                            //if($deletePastRSDetail){
                                $this->TempItemSerializedModel->insertSerialDataFromTemp($RecSerialDetail);
                            //}
                        }
                    }
                }else{                    
                    return $this->response->setJSON([
                        'error' => false,
                        'icon' => 'success'
                    ]);
                }
            }
        }
    }
    
    // save temp reccord from temp to origin
    public function saveRecItemFromTemp()
    {
        $validation = \Config\Services::validation();
        $request = \Config\Services::request();
        $validation = $validation->withRequest($request);

        $formdata = $this->request->getPost('frmData');
        $tableData = $this->request->getPost('tableData');
        parse_str($formdata, $parseData);

        $Rec = [];
        $RecDetail = [];
        $RecStocks = [];
        $serialInputs = [];
        $RecSerialDetail = [];
        $BNo = $this->checkBatchNo();

        $rules = [
            'SupplierID' => 'required',
            'UserID' => 'required',
            'RNet' => 'required',
            'RNetwithtax' => 'required',
            'RPaymentType' => 'required',
        ];

        if($parseData){
            $Rec = [
                'SupplierID' => $parseData['supplier'],
                'RType'  => $parseData['recMode'],
                'UserID'  => $parseData['userId'],
                'RBatchNo' => $BNo,
                'RComment'  =>$parseData['comments'],
                'RNet'  =>$parseData['subtot'],
                'RNetwithtax'  => $parseData['tot'],
                'RPaymentType'  => $parseData['payType'],
                'RCreatedAt' => $this->now,
                'RStatus'=>'1'
            ];
        }

        //$validation->setRules($rules);
        
        // if($validation->run($Rec)){
        //     return $Rec;
        // }
        
        $Reclast_id = $this->ReceivingModel->insertRecData($Rec);
        
        if($tableData){
            //var_dump($tableData);
            foreach($tableData as $tData){
                //var_dump($tData);
                //check and compare with base units
                $convertedUnit = '';
                $check_items_base_unit = $this->ItemsModel->getItemBaseUnit($tData['itemid']);
                //var_dump($check_items_base_unit);
                //var_dump($check_items_base_unit->ItemUnit);
                //var_dump($tData['unit']);
                if($check_items_base_unit->ItemUnit != $tData['unit']){
                    $covertion_factor = $this->ConversionFactorModel->getConvertionRate($tData['unit'], $check_items_base_unit->ItemUnit);
                    //var_dump($covertion_factor);
                    foreach($covertion_factor as $cfrow){ 
                        //var_dump($cfrow->CFFactor);                       
                        $convertedUnit = (int)$cfrow->CFFactor * $tData['qty'];
                        //var_dump($convertedUnit);
                    }
                }else{
                    //var_dump("Units no need to convert");
                    $convertedUnit = $tData['qty'];
                }
                
                $i = 0;
                $RecDetail = [
                    'RID' => $Reclast_id,
                    'ItemID' => (int)$tData['itemid'],
                    'RDIsSerialized' => $tData['serialized'],
                    'RDLine' => $i,
                    'RDQty' => $tData['qty'],
                    'RDUnit' => $tData['unit'],
                    'RDCostPrice' => $tData['price'],
                    'RDSellingPrice' => $tData['sellprice'],
                    'RDMFD' => $tData['manDate'],
                    'RDEXP' => $tData['expDate'],
                    'RDiscount' => $tData['disc'],
                    'RAmount' => $tData['ramount'],
                    'RDCreatedAt' => $this->now
                ];
                $i++;
                $RecStocks = [
                    'ItemID' => (int)$tData['itemid'],
                    'BatchNo' => $BNo,
                    'Unit' => $tData['unit'],
                    'Qty' => $tData['qty'],
                    'Price' => $tData['sellprice'],
                    'MFDate' => $tData['manDate'],
                    'ExpDate' => $tData['expDate'],
                    'StockCreatedAt' => $this->now,
                    'StockStatus' => '1'
                ];
                //var_dump($RecDetail);
                //var_dump($RecStocks);

                $this->StocksModel->insertStockData($RecStocks);
                $last_id = $this->ReceivingDetailModel->saveData($RecDetail);

                //var_dump($tData['serialData']);
                if($tData['serialData'] != '' && $tData['serialized'] == '1'){
                    $serialInputs = json_decode($tData['serialData'], true);
                    //var_dump($serialInputs);
                    foreach ($serialInputs as $serial){
                        //var_dump($serial);
                        $RecSerialDetail['RDID'] = $last_id;
                        $RecSerialDetail['item_id'] = $tData['itemid'];
                        $RecSerialDetail['receiving_id'] = $Reclast_id;
                        $RecSerialDetail['serial_number'] = $serial['serial_number'];
                        $RecSerialDetail['item_status'] = $serial['item_status'];
                        $RecSerialDetail['warranty_period'] = $serial['warranty_period'];
                        $RecSerialDetail['is_available_in_stock'] = '1';
                        $RecSerialDetail['created_at'] = $this->now;
                        //var_dump($RecSerialDetail);
                        $finalInsert = $this->ReceivingSerialDetailModal->insertSerialData($RecSerialDetail);
                    }                    
                    //var_dump($RecSerialDetail);
                }

                //insert purchasing price
                $purchasingData = [                    
                    'item_id' => (int)$tData['itemid'],
                    'item_name' => '',
                    'purchasing_price' => $tData['price'],
                    'batch_number' => $BNo,
                    'created_at' => $this->now,
                    'created_by' => $parseData['userId']
                ];

                $this->PurchasingPriceModel->insertData($purchasingData);
            }
        }
        
        $this->TempReceivingModel->deletePreviousRecRecord($parseData['RecCartID']);
        $this->TempReceivingDetailModel->deletePreviousRecord($parseData['RecCartID']);
        $this->TempItemSerializedModel->deletePreviousSerialRecord($parseData['RecCartID']);

        return $this->response->setJSON([
            'error'=>false,
            'message'=>$Reclast_id,
            'title' => 'Success',
            'text' => 'Receiving Stored Successfully',
            'icon' => 'success'
        ]);
    }

     //check previous batch no and generate batch no
     public function checkBatchNo()
     {
         $preData = $this->ReceivingModel->checkBatchNo();
         //var_dump($preData);
         // Get the previous batch number from the database
         $previousBatchNumber = $this->ReceivingModel->checkBatchNo(); // example value
 
         $batchno = null;
         foreach($previousBatchNumber as $pbn):
             $batchno = $pbn['RBatchNo'];
         endforeach;
         // Extract the numeric portion of the previous baton number
         $previousBatchNumberNumeric = (int)substr($batchno, 1);
 
         // // Increment the numeric portion
         $newBatchNumberNumeric = $previousBatchNumberNumeric + 1;
 
         // // Format the new baton number
         $newBatchNumber = "B" . sprintf('%04d', $newBatchNumberNumeric);
 
         return $newBatchNumber;
     }
    
    //get single data
    public function singleRecData($id = null) 
    {
        $receivingsData = $this->TempReceivingModel->getSingleRecData($id);
        //var_dump($data);
        if($receivingsData){
            //echo $data;
            $recDetailData = $this->TempReceivingDetailModel->getSingleRecDetailData($id);
            $recSerialData = $this->TempItemSerializedModel->getSingleData($id);
            //$OrginItemID = $recDetailData['ItemID'];
            //var_dump($array);
            $array = json_decode(json_encode($recDetailData), true);
            //var_dump($array);
            $OriginSerialData = [];
            foreach($array as $a){
                //var_dump($a['ItemID']);
                $OriginSerialData[$a['ItemID']] = $this->ReceivingSerialDetailModal->getSingleData($a['ItemID']);
                //var_dump($OriginSerialData);
            }
            
            //var_dump($a['ItemID']);
            //var_dump($OriginSerialData);
            $data = [
                'receivingsData' => $receivingsData,
                'recDetailData' => $recDetailData,
                'recSerialData' => $recSerialData,
                'OriginSerialData' => $OriginSerialData
            ];
            return $this->response->setJSON($data);
            //echo json_encode(array("status" => true , 'data' => $data));
        }else{            
            //echo "Error"; 
            echo json_encode(array("status" => false));
        }
    }

    public function discardData()
    {
        $id = $this->request->getPost('CartID');
        // var_dump($id);
        if($id != ''){
            $this->TempReceivingModel->deletePreviousRecRecord($id);
            $this->TempReceivingDetailModel->deletePreviousRecord($id);
            $this->TempItemSerializedModel->deletePreviousSerialRecord($id);

            $data = [
                'error' => false,
                'title' => 'Discarded',
                'message' => 'Discarded Successfully!',
                'icon' => 'success'
            ];
            return $this->response->setJSON($data);
        }
    }

    public function singleserialDataByItemCartID($cart_id = null, $item_id = null)
    {
        $data = [
            'cart_id' => $cart_id,
            'item_id' => $item_id
        ];
       
        return $this->response->setJSON($data);
    }
}
