<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class UserRole extends Migration
{
    public function up()
    {
        //Create UserRole Table
        $this->forge->addField([
            'URoleID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'URName' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],   
            'URCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'URCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'URUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'URUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'URDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'URDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('URoleID');
        $this->forge->createTable('userrole');
    }

    public function down()
    {
        //Drop UserRole Table
        $this->forge->dropTable('userrole');
    }
}
