<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Manufacturers extends Migration
{
    public function up()
    {
         //Create Manufacturers Table
         $this->forge->addField([
            'MID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'MLicNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MImg' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MCompanyName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MNIC' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MAddressLine1' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MAddressLine2' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MCity' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MProvince' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MCountry' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MContactNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MEmail' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MDescription' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MBankName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MBankAcNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'MCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'MUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'MDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'MStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('MID');
        $this->forge->createTable('manufacturers');
    }

    public function down()
    {
        //Drop Manufacturer Table
        $this->forge->dropTable('manufacturers');
    }
}
