<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Item extends Migration
{
    public function up()
    {
        //Create Item Table
        $this->forge->addField([
            'ItemID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ItemCategory' => [
                'type' => 'INT'
            ],
            'ItemName' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'ItemImg' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemTags' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemDescription' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemUnit' => [
                'type' => 'INT'
            ],
            'ItemReorderLevel' => [
                'type' => 'INT'
            ],
            'ItemOtherUnits' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemType' => [
                'type' => 'INT'
            ],
            'ItemStatusValue' => [
                'type' => 'INT'
            ],
            'ItemIsSerialized' => [
                'type' => 'INT'
            ],
            'ItemReturnable'=>[
                'type' => 'INT',
                'default'=>'1'
            ],
            'ItemCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ItemCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'ItemUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ItemUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'ItemDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ItemDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('ItemID');
        $this->forge->createTable('item');
    }

    public function down()
    {
        //Drop Item Table
        $this->forge->dropTable('item');
    }
}
