<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CustomerContactInformation extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'=>[
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'customer_id'=>[
                'type' => 'INT',
            ],
            'address'=>[
                'type'=> 'varchar',
                'constraint' => 255,
            ],
            'phone_number'=>[
                'type'=> 'varchar',
                'constraint' => 10,
                // 'unique'     => true,
            ],
            'email'=>[
                'type' => 'varchar',
                'constraint' => 50,
                // 'unique'     => true,
            ],
            'is_default'=>[
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('customer_contact_information');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('customer_contact_information');
    }
}
