<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Units extends Migration
{
    public function up()
    {
        //Create Units Table
        $this->forge->addField([
            'UnitID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            // 'FromUnitiD' => [
            //     'type' => 'INT'
            // ],
            // 'ToUnitID' => [
            //     'type' => 'INT'
            // ],
            'UnitName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'UnitAbbreviation' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'base_unit_id' => [
                'type' => 'INT',
                'default' => 0,
            ],
            'is_base_unit' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
            'UnitCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UnitCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'UnitUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UnitUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'UnitDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
             'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);
        // UnitStatus
        $this->forge->addPrimaryKey('UnitID');
        //$this->forge->addForeignKey('FromUnitiD', 'conversionfactor', 'FromUnitiD', 'CASCADE', 'CASCADE');
        //$this->forge->addForeignKey('ToUnitID', 'conversionfactor', 'ToUnitID', 'CASCADE', 'CASCADE');
        $this->forge->createTable('units');
    }

    public function down()
    {
        //Drop Units Table
        $this->forge->dropTable('units');
        // // gives CONSTRAINT `TABLENAME_units` FOREIGN KEY(`FromUnitiD`) REFERENCES `conversionfactor`(`FromUnitiD`) ON DELETE CASCADE ON UPDATE CASCADE
    }
}
