<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class SaleItems extends Migration
{
    public function up()
    {
        //Create Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'sale_id' => [
                'type' => 'INT',
            ],
            'item_id' => [
                'type' => 'INT',
            ],
            'batch_no' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'price' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'discount' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
               'default' => 0,
            ],
            'qty' => [
                'type' => 'INT',
            ],
            'authorized_by'=>[
                'type' => 'INT',
                'null' => true,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('sale_items');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('sale_items');
    }
}
