<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class TempReceivingdetails extends Migration
{
    public function up()
    {
         //Create Receiving details Table
         $this->forge->addField([
            'RDID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'CartID' => [
                'type' => 'TEXT',
            ],
            'RID' => [
                'type' => 'INT',
            ],
            'ItemID' => [
                'type' => 'INT',
            ],
            'RDIsSerialized' => [
                'type' => 'INT',
            ],
            'RDLine' => [
                'type' => 'INT',
            ],
            'RDQty' => [
                'type' => 'INT'
            ],
            'RDUnit' => [
                'type' => 'varchar',
                'constraint' => 30,
            ],
            'RDCostPrice' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RDSellingPrice' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RDCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('RDID');
        $this->forge->createTable('temp_receivingdetails');
    }

    public function down()
    {
          //Drop receiving Table
          $this->forge->dropTable('temp_receivingdetails');
    }
}
