<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class TempItemSerialized extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'CartID' => [
                'type' => 'TEXT',
            ], 
            'RDID' => [
                'type' => 'INT',
                'constraint' => 255,
            ],
            'item_id' => [
                'type' => 'INT',
            ],
            'receiving_id' => [
                'type' => 'INT',
            ],
            'sale_id' => [
                'type' => 'INT',
                'null' => true,
            ],
            'serial_number' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'item_status' => [
                'type' => 'INT',
                'comment' => 'new: 1, used: 2, aging: 3, damaged: 4',
                'default' => 1,
            ],
            'warranty_period' => [
                'type' => 'INT',
                'null' => true,
            ],
            'is_available_in_stock' => [
                'type' => 'INT',
                'comment' => 'yes: 1, no: 2',
                'default' => 1,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('temp_itemserialized');
    }
    public function down()
    {
        $this->forge->dropTable('temp_itemserialized');
    }
}
