<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Models\CommonModel;

class CustomerLoyaltiesModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'customer_loyalties';
    protected $primaryKey       = 'DelID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['customer_id','sale_id', 'loyalty_percentage', 'amount', 'exp_date', 'is_cash', 'authorized_by', 'auth_code','is_redeemed','created_at','updated_at','deleted_at','delete_flag','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    //construct function
    public function __construct(){    
        $this->common = new CommonModel();   
        $this->db = \Config\Database::connect();
    }
    // insert data
    function insertData($data)
	{
        return $this->db->table('customer_loyalties')->insert($data);
	}
    //get specific data
    function getSpecificData($id){
        return $this->db->table('customer_loyalties')->where(["id" => $id])->get()->getRow();
    }
    // get all data
    function index(){
        $data= $this->db->table('customer_loyalties')->where('delete_flag', 0)->orderBy('id ', 'ASC')->get()->getResultArray();
        return $data;
    }
    // update data
    function updateData($id,$data){
        return $this->db->table('customer_loyalties')->where(["id" => $id])->set($data)->update();
    }
    // delete delete
    function deleteData($id,$data){
        return $this->db->table('customer_loyalties')->where(["id" => $id])->set($data)->update();
    }
    //set customer loyalty redeem data
    function setCustomerLoyaltyRedeemData($pay_amount,$customer_id){
        //check if has loyalty validity period
        $loyalty_point_validity_period = ($this->common->getSpecificColumnValueByGivenColumnName('masterconfig','id','loyalty_point_validity_period',1,'delete_flag',0))->loyalty_point_validity_period;
        if($loyalty_point_validity_period != 0){
            //order by exp date and get customer loyalties records
            $ordered_customer_loyalties = $this->db->table('customer_loyalties')->where('amount !=', 0)->where('exp_date !=', null)->where(["customer_id" => $customer_id])->where(["delete_flag" => 0])->orderBy('exp_date', 'ASC')->get()->getResultArray();
        }
        else{
            //order by id to get customer loyalties records
            $ordered_customer_loyalties = $this->db->table('customer_loyalties')->where('amount !=', 0)->where('exp_date', null)->where(["customer_id" => $customer_id])->where(["delete_flag" => 0])->orderBy('id', 'ASC')->get()->getResultArray();
        }
        if($ordered_customer_loyalties != null){
            $customer_loyalty_ids = [];
            $customer_loyalty_amounts = []; 
            //check if can be paid from single loyalty record
            if((int)$pay_amount < (int)($ordered_customer_loyalties[0]['amount'])){
                array_push($customer_loyalty_ids,(int)($ordered_customer_loyalties[0]['id']));
                array_push($customer_loyalty_amounts,(int)$pay_amount);
            }
            else{
                $paid_amount = 0;
                $due_amount = 0;
                $total_paid = 0;
                $paid_amount = (int)($ordered_customer_loyalties[0]['amount']);
                $due_amount = (int)$pay_amount - (int)$paid_amount;
                array_push($customer_loyalty_ids,(int)($ordered_customer_loyalties[0]['id']));
                array_push($customer_loyalty_amounts,(int)$paid_amount);
                for($i=0;$i<count($ordered_customer_loyalties);$i++){
                    if((int)$due_amount < (int)($ordered_customer_loyalties[$i+1]['amount'])){
                        $paid_amount = (int)$due_amount;
                        $due_amount = 0;
                        array_push($customer_loyalty_ids,(int)($ordered_customer_loyalties[$i+1]['id']));
                        array_push($customer_loyalty_amounts,(int)$paid_amount);
                        if(array_sum($customer_loyalty_amounts) == $pay_amount) break;
                    }
                    else{
                        $total_paid = (int)$paid_amount;
                        $paid_amount = (int)($ordered_customer_loyalties[$i+1]['amount']);
                        $total_paid = (int)$total_paid + (int)$paid_amount;
                        $due_amount = (int)$pay_amount - (int)$total_paid;
                        array_push($customer_loyalty_ids,(int)($ordered_customer_loyalties[$i+1]['id']));
                        array_push($customer_loyalty_amounts,(int)$paid_amount);
                        if(array_sum($customer_loyalty_amounts) == $pay_amount) break;
                    }
                }
            }
        }
        $redeem_loyalty_data['customer_loyalty_ids'] = $customer_loyalty_ids;
        $redeem_loyalty_data['customer_loyalty_amounts'] = $customer_loyalty_amounts;
        return $redeem_loyalty_data;
    }
}
