<?php

namespace App\Models;

use CodeIgniter\Model;

class MasterConfigModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'masterconfig';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['company_name','address','contact_number','time_zone','currency', 'multi_language', 'business_type', 'location', 'store_type', 'is_serialized', 'customer_payment_term','supplier_payment_term', 'has_exp_mod_date', 'loyalty_percentage','payment_type','backup_type','loyalty_point_validity_period','tax','has_online_store','tenant_id','Comment','type'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];


    // get all masterconfig data
    function index()
    {
        $data= $this->db
        ->table('masterconfig')
        ->where('delete_flag', '0')
        ->orderBy('id ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }
    // get  location data
    function indexLocation()
    {
        $data= $this->db
        ->table('masterconfig')
        ->where('delete_flag', '0')
        ->orderBy('id ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }
    // save masterconfig data
    function insertData($data)
	{
        return $this->db
        ->table('masterconfig')
        ->insert($data);
	}

    // get single masterconfig data
    function getSingleData($id)
    {
        return $this->db
             ->table('masterconfig')
             ->where(["id" => $id])
             ->get()
             ->getRow();
    }
    // update masterconfig data
    function updateData($id,$data)
    {
        return $this->db
        ->table('masterconfig')
        ->where(["id" => $id])
        ->set($data)
        ->update();
    }
    // delete masterconfig data
    function deleteData($id,$data)
    {
        return $this->db
        ->table('masterconfig')
        ->where(["id" => $id])
        ->set($data)
        ->update();
    }
    

}
