<?php

namespace App\Models;

use CodeIgniter\Model;

class ReceivingSerialDetailModal extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'item_serialized';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['RDID', 'item_id', 'receiving_id', 'sale_id','serial_number','item_status','warranty_period','created_at','updated_at','deleted_at','delete_flag','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // insert receiving serial data to db
    function insertSerialData($data)
    {
        return $this->db
            ->table('item_serialized')
            ->insert($data);      
       
    }
    //get specific item serialized data
    function getSpecificSerializedData($item_id, $serial_number){
        return $this->db->table('item_serialized')->where(["item_id" => $item_id])->where(["serial_number" => $serial_number])->where(["is_available_in_stock" => 1])->get()->getRow();
    }
    // update data
    function updateData($id,$data){
        return $this->db->table('item_serialized')->where(["id" => $id])->set($data)->update();
    }
    //get specific item serialized data
    function getSingleData($item_id){
        return $this->db->table('item_serialized')->where(["item_id" => $item_id])->get()->getResult();
    }
    //get seril item warranty period by serial number
    function getWarrantyPeriod($serial_number){
        return $this->db->table('item_serialized')->where(["serial_number" => $serial_number])->where(["is_available_in_stock" => 1])->get()->getRow();
    }
}
