<?php

    namespace App\Models;

    use CodeIgniter\Model;

    class SalesModel extends Model{

        protected $table      = 'sales';
        protected $primaryKey = 'id';

        protected $useAutoIncrement = true;

        protected $returnType     = 'array';
        protected $useSoftDeletes = false;

        protected $allowedFields = ['pos_id', 'user_id', 'customer_id', 'sale_type_id', 'total_amount', 'discount_amount', 'created_at','updated_at','deleted_at','delete_flag'];
        
        // Dates
        protected $useTimestamps = false;
        protected $dateFormat    = 'datetime';
        protected $createdField  = 'created_at';
        protected $updatedField  = 'updated_at';
        protected $deletedField  = 'deleted_at';

        // Validation
        protected $validationRules      = [];
        protected $validationMessages   = [];
        protected $skipValidation       = false;
        protected $cleanValidationRules = true;

        // Callbacks
        protected $allowCallbacks = true;
        protected $beforeInsert   = [];
        protected $afterInsert    = [];
        protected $beforeUpdate   = [];
        protected $afterUpdate    = [];
        protected $beforeFind     = [];
        protected $afterFind      = [];
        protected $beforeDelete   = [];
        protected $afterDelete    = [];

         // get all data
        function index(){
            $data= $this->db->table('sales')->where('delete_flag', 0)->orderBy('id ', 'ASC')->get()->getResultArray();
            return $data;
        }
        // insert data
        function insertData($data)
        {
            return $this->db->table('sales')->insert($data);
        }
        //get specific data
        function getSpecificData($id){
            return $this->db->table('sales')->where(["id" => $id])->get()->getRow();
        }
        //store sales
        function storeSale(){
            
        }
    }

?>