<?php $this->extend('layouts/master') ?>

<?php $this->section('gift_voucher_sale') ?>
<style>
   input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
    }
</style>

        <!--- Sale Status --->
        <div class="container-fluid mt-3">
            <div class="row">
                <div class="col-8">
                    <div class="row">
                        <div class="col-4 ps-0">
                            <!-- <div class="d-flex bd-highlight bg-third text-secondary py-1 Bardcode-scn">
                                <div class="p-2 flex-fill bd-highlight fw-bold">Scan Bardcode</div>
                                <div class="flex-fill bd-highlight csn-btn btn linear-bg"><img class="mt-1" src="./assets/images/icons/scanner1.svg">
                                </div>
                            </div> -->
                        </div>
                        <div class="col-12 pe-0">
                            <div class="d-flex bd-highlight bg-third text-secondary py-1 customer-select ps-1">
                                <div class="pt-2 ps-2 flex-fill bd-highlight fw-bold">Customer ID: 
                                    <input type="text" id="customer_id" name="customer_id" class="customer_id" readonly required>
                                </div>
                                <div class="pt-2 ps-2 flex-fill bd-highlight fw-bold">Customer Phone Number: 
                                    <input type="text" id="customer_phone_number" name="customer_phone_number" class="customer_phone_number">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 me-3 ms-1 bill-area">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Sale Type</div>
                                            <div class="flex-fill bd-highlight">
                                                <select class="form-select ms-2 py-0 text-primary fw-bold"
                                                    aria-label="Default select example" id="sale_type" name="sale_type">
                                                    <option value="0" disable>---Select Sale Type---</option>
                                                    <option value="3" selected>Gift Voucher</option>
                                                </select>
                                                <input type="text" hidden id="payment_authorized_by_id" name="payment_authorized_by_id">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Currency</div>
                                            <div class="flex-fill bd-highlight">
                                                <select class="form-select ms-2 py-0 text-primary fw-bold"
                                                    aria-label="Default select example">
                                                    <option selected>LKR</option>
                                                    <option value="1">AUS</option>
                                                    <option value="2">IDR</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                           <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table" id="voucher_sale_tbl_div">
                                <div class="tableFixHead mt-2">
                                <div class="mb-2">
                                    <button type="button" class="btn linear-bg text-secondary  px-2 py-0" id="add_voucher_row" name="add_voucher_row"  data-toggle="tooltip" data-placement="top" title="Add More Voucher Data"><i class="bi bi-plus-lg fw-bold"></i></button>
                                    <button style="display:none;" class="btn linear-bg text-secondary px-2 py-0" id="generate_voucher_key" name="generate_voucher_key" data-toggle="tooltip" data-placement="top" title="Generate Voucher Key"><i class="bi bi-chat-square-dots"></i></button>             
                                    <button type="button" class="delete-row btn linear-bg text-secondary px-2 py-0">Delete Row</button>
                                </div>
                                <table id="voucher_data_table" class="table rounded align-middle">
                                    <thead class="text-center text-secondary rounded">
                                            <th scope="col">Select</th>
                                            <th scope="col">Voucher Type</th>
                                            <th scope="col">Serial No</th>
                                            <th scope="col">Voucher Name</th>
                                            <th scope="col">Amount</th>
                                            <th scope="col">Issued Date</th>
                                            <th scope="col">Expire Date</th>
                                        </thead>
                                        <tbody class="text-primary fw-bold">
                                        <tr>
                                            <td><input type="checkbox" name="record"></td>
                                            <td>
                                                <input type="radio" class="voucher_type" value="e_voucher">
                                                <label for="e_voucher">e</label><span style="color:white;">AAA</span>
                                                <input type="radio" class="voucher_type" value="normal_voucher" checked>
                                                <label for="normal_voucher">normal</label>
                                            </td>
                                            <td>
                                                <input type="text" name="serial_number" class="serial_number">
                                            </td>
                                            <td>
                                                <input type="text" name="voucher_name" class="voucher_name">
                                            </td>
                                            <td>
                                                <input type="number" name="voucher_amount" class="voucher_amount">
                                            </td>
                                            <td>
                                                <input type="date" value="<?php echo set_value('issue_date');?>" name="issue_date" placeholder="Enter Gift Card Issue Date" class="issue_date">
                                            </td>
                                            <td>
                                                <input type="date"  value="<?php echo set_value('exp_date');?>" name="exp_date" placeholder="Enter Gift Card Expire Date" class="exp_date">
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-4">
                    <div class="linear-bg rounded-15 p-2">
                        <div class="bill-box rounded-15 bg-secondary p-1">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Sub Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input readonly type="text" id="sub_total" name="sub_total"></input></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="bill-box rounded-15 bg-secondary p-1 my-2">
                        <table class="table table-borderless my-0">
                            <tbody class="text-primary fw-bold ">
                                <tr>
                                    <td class="py-0">Payment Total</td>
                                    <td class="text-end py-0">Rs</td>
                                    <td class="py-0"><input type="text" readonly id="payment_total" name="payment_total" value="0"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="container bill-option-btn-set mt-2 py-2">
                        <div class="row mt-2">
                            <div class="col p-0" id="add_payment_btn" name="add_payment_btn" style="cursor:pointer">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/plus-lg.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">Add Payment</div>
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0" id="edit_payment_btn" name="edit_payment_btn" style="cursor:pointer;display:none;">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/plus-lg.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">Edit Payment</div>
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0">
                                <div id="end_sale_btn" name="end_sale_btn" style="cursor:pointer !important"
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a id="end_sale" name="end_sale">
                                        <img src="./assets/images/icons/forward.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">End Sale</div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Sale Status End --->
        <!--Multiple selling price selection modal: start-->
        <div class="modal fade" id="submit_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Multiple selling price selection</h5>
                        <button id="close_modal" type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3 col">
                            <label for="" class="col-form-label">Select Selling Price:</label>
                            <div id="multiple_selling_price_list" name="multiple_selling_price_list">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Multiple selling price selection modal: end-->
        <!--Item serial data enter modal: start-->
        <div class="modal fade" id="serial_data_enter_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Enter Item Serial Data</h5>
                        <button id="close_serial_modal" type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="serial_data_enter_modal_body">
                        <div class="row" id="initial_serial_div" name="initial_serial_div">          
                            <input hidden type="text" class="serial_item_id" id="serial_item_id" name="serial_item_id">                      
                            <div class="mb-3 col">
                                <label for="" class="col-form-label">Serial Number:</label>
                                <input type="text" class="serial_number" id="serial_number" name="serial_number">
                            </div>
                            <div class="mb-3 col">
                                <label for="" class="col-form-label">Warranty Period:</label>
                                <input type="text" class="warranty_period" id="warranty_period" name="warranty_period">
                            </div>
                        </div>    
                        <div class="row" id="additional_serial_div" name="additional_serial_div">

                        </div>  
                        <div class="mb-3 col">
                                <button type="button" class="btn linear-bg text-secondary" id="add_another_serial_btn" name="add_another_serial_btn"><i class="bi bi-plus-lg fw-bold"></i></button>
                        </div>      
                    </div>
                </div>
            </div>
        </div>
        <!--Item serial data enter modal: end-->
        <!--Payment data enter modal: start-->
        <div class="modal fade" id="payment_data_enter_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <input type="text" id="keep_payment_modal_open" name="keep_payment_modal_open" hidden>
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Enter Payment Data</h5>
                        <button id="close_payment_data_modal" type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="payment_data_enter_modal_body">
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="toal">Total:</label>
                                <input type="text" id="total" name="total" readonly style="width:20%;">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="payment_type" class="col-form-label">Payment Type:</label>
                                <select class="form-control" name="payment_type" id="payment_type" >
                                    <option value="" selected disabled>--Select Payment Type--</option>
                                    <option value="1">Cash</option>
                                    <option value="2">Credit card</option>
                                    <option value="3">Debit card</option>
                                    <option value="4">Cheque</option>
                                </select>
                            </div>
                        </div>
                        <div class="row" id="bank_div" name="bank_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="bank_lbl" for="bank" class="col-form-label">Bank:</label>
                                <select class="form-control" name="bank" id="bank" >
                                    <option value="" selected disabled>--Select Bank--</option>
                                    <?php foreach($banks as $bank){?>
                                        <option value="<?php echo $bank['BID'] ;?>" <?php echo set_select('bank',$bank['BID']);?>><?php echo $bank['BankName'];?></option>"
                                    <?php }?>
                                </select>
                            </div>
                        </div>
                        <div class="row" id="cheque_div" name="cheque_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="cheque_no_lbl" for="cheque_no" class="col-form-label">Cheque No:</label>
                                <input type="text" class="" id="cheque_no" name="cheque_no">
                            </div>
                        </div>
                        <div class="row" id="card_no_div" name="card_no_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="card_no_lbl" for="card_no" class="col-form-label">Card No:</label>
                                <input type="text" class="" id="card_no" name="card_no">
                            </div>
                        </div>
                        <div class="row" id="payment_method_div" name="payment_method_div" style="display:none;">
                            <div class="mb-3 col">
                                <input type="text" class="" id="payment_method" name="payment_method" hidden>
                                <label id="payment_method_lbl" for="payment_method" class="col-form-label">Payment Method:</label><br><span style="color:white;">AAA</span>
                                <img src="<?= $visa_logo ?>" alt="" id="payment_method_visa" name="payment_method_visa" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $master_logo ?>" alt="" id="payment_method_master" name="payment_method_master" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $amex_logo ?>" alt="" id="payment_method_amex" name="payment_method_amex" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $cash_cheque_logo ?>" alt="" id="payment_method_cash_cheque" name="payment_method_cash_cheque" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $account_pay_logo ?>" alt="" id="payment_method_account_pay" name="payment_method_account_pay" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                            </div>
                        </div>
                        <div class="row" id="exp_date_div" name="exp_date_div"  style="display:none;">
                            <div class="mb-3 col">
                                <label id="exp_date_lbl" for="exp_date" class="col-form-label">Exp Date:</label>
                                <input type="date" class="form-control" name="exp_date" id="exp_date">
                            </div>
                        </div> 
                        <br>
                        <div class="mb-3 col">
                            <button type="button" name="submit_payment_data" id="submit_payment_data" class="btn linear-bg text-secondary">Submit Payment</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Payment data enter modal: end-->

    </section>
    <?php echo view('includes/footer'); ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            window.payment_data_ar = [];
            window.voucher_type_btns = [];
            $("#sub_total").val(0);
            $('[data-toggle="tooltip"]').tooltip();
            $("#customer_id").val('1');
            setIds();
        });
        //set ids
        function setIds(){
            $('input[name=serial_number]').each(function(index, el) {
                $(this).attr('id',"serial_number_"+(index+1));
            });
            $('input[name=voucher_name]').each(function(index, el) {
                $(this).attr('id',"voucher_name_"+(index+1));
            });
            $('input[name=voucher_amount]').each(function(index, el) {
                $(this).attr('id',"voucher_amount_"+(index+1));
            });
            $('input[name=issue_date]').each(function(index, el) {
                $(this).attr('id',"issue_date_"+(index+1));
            });
            $('input[name=exp_date]').each(function(index, el) {
                $(this).attr('id',"exp_date_"+(index+1));
            });
            voucher_type_btns = document.getElementsByClassName('voucher_type');
            for (var i = 0; i < voucher_type_btns.length; i++) {
                voucher_type_btns[i].setAttribute('id', 'voucher_type_' + (i + 1));
                if(i == 0){
                    voucher_type_btns[i].setAttribute('name', 'voucher_type_' + (i + 1));
                }
                else{
                  
                }
            }
            
            enableVoucherKeyButton();
        }
        //show/hide generate voucher key button
        function enableVoucherKeyButton(){
            for (var i = 0; i < voucher_type_btns.length; i++) {
                voucher_type_btns[i].addEventListener('change', function() {
                    console.log('Value changed to: ' + this.value);
                    if(this.value == 'e_voucher'){
                        $("#generate_voucher_key").show();
                    }
                    else if(this.value == 'normal_voucher'){
                        $("#generate_voucher_key").hide();
                    }
                });
            }
        }
        //add another voucher data
        $("#add_voucher_row").on("click",function(e){
            var markup = '<tr><td><input type="checkbox" name="record"></td><td><input type="radio" class="voucher_type" value="e_voucher"><label for="e_voucher">e</label><span style="color:white;">AAA</span><input type="radio" class="voucher_type"  value="normal_voucher" checked><label for="normal_voucher">normal</label></td><td><input type="text" name="serial_number" class="serial_number"></td><td><input type="text" name="voucher_name" class="voucher_name"></td><td><input type="number" class="voucher_amount" name="voucher_amount"></td><td><input type="date" class="issue_date"  value="<?php echo set_value('issue_date');?>" name="issue_date" placeholder="Enter Gift Card Issue Date"></td><td><input type="date" class="exp_date" value="<?php echo set_value('exp_date');?>" name="exp_date" placeholder="Enter Gift Card Expire Date"></td></tr>';
            $("#voucher_data_table tbody").append(markup);
            setIds();
        });
        // Find and remove selected table rows
        $(".delete-row").click(function(){
            $("#voucher_data_table tbody").find('input[name="record"]').each(function(){
            	if($(this).is(":checked")){
                    $(this).parents("tr").remove();
                }
            });
        });
        //get amount sum
        function setSubTotal(){
            var total_arr = $.map($('.voucher_amount'), function (el) { return el.value; });
            var total_amount = 0;
            for (var i = 0; i < total_arr.length; i++) {
                total_amount += total_arr[i] << 0;
            }
            $("#sub_total").val(total_amount);
            $("#total").val(total_amount);
        }
        //update amount data
        $("#voucher_sale_tbl_div").on("click",function(e){
            setSubTotal();
        });
        //set payment data
        function setPaymentData(){
            $("#payment_total").val($("#sub_total").val());
        }
        //payment options
        $("#add_payment_btn").click(function(event){
            setSubTotal();
            $("#payment_data_enter_modal").modal('toggle'); 
            $("#payment_data_enter_modal").modal('show');
        });
         //submit payment data
         $('#submit_payment_data').on('click',function(e){
            submitPaymentData();
            setPaymentData();
        });
        function submitPaymentData(){
            //get entered values
            var payment_type = $("#payment_type").val();
            var payment_amount = parseInt($('#payment_amount').val());
            var bank = $("#bank").val();
            var cheque_no = $("#cheque_no").val();
            var card_no = $("#card_no").val();
            var payment_method = parseInt($('#payment_method').val());
            var exp_date = $("#exp_date").val();
            var payment = $('#submit_payment_data').text();
            //set null if not entered
            if(cheque_no == '')
                cheque_no = null;
            if(card_no == '')
                card_no = null;  
            if(payment_method == '')
                payment_method = null;  
            if(exp_date == '')
                exp_date = null;
            //add to payment data array
            //format: payment_type,amount,bank,cheque,card,payment_method,exp
            payment_data_ar.push(payment_type+','+payment_amount+','+bank+','+cheque_no+','+card_no+','+payment_method+','+exp_date);
            //reset payment data modal fields
            $("#payment_type").val('');
            $('#payment_amount').val('');
            $("#bank").val('');
            $("#cheque_no").val('');
            $("#card_no").val('');
            $("#payment_method").val('');
            $("#exp_date").val('');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
            console.log(payment_data_ar);
            var net_total = parseInt($("#total").val());
            var paid = 0;
            $.each(payment_data_ar, function(index, element) {
                var values = element.split(',');
                paid += parseInt(values[1]);
            });
            var due = net_total-paid;
            current_due_amount = due;
            $("#payment_total").val(paid);
            $("#payment_data_enter_modal").modal('hide');
            //disable add payment button
            if($("#payment_total").val() != 0){
                $("#add_payment_btn").hide();
                $("#edit_payment_btn").show();
            }
            //enable add payment button
            //payment options
            $("#edit_payment_btn").click(function(event){
                Swal.fire({
                    title: 'Enter Auth Key',
                    input: 'password',
                    inputAttributes: {
                        autocapitalize: 'off'
                    },
                    showCancelButton: true,
                    confirmButtonText: 'Authorize',
                    showLoaderOnConfirm: true,
                    preConfirm: (auth_key) => {
                    },
                    allowOutsideClick: () => !Swal.isLoading()
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        var entered_auth_key = result.value;
                        //check for authoization
                        $.ajax({
                            url: 'user_modify_sale_check_authorization/'+ entered_auth_key,
                            type: "GET",
                            data: {
                                entered_auth_key: entered_auth_key,
                            },
                            success: function(response) {
                                console.log(response);
                                var is_authorized = response.is_authorized;
                                var authorized_by = response.authorized_by;
                                if(is_authorized){
                                    $("#add_payment_btn").show();
                                    $("#edit_payment_btn").hide();
                                    $("#payment_authorized_by_id").val(authorized_by);
                                    $("#payment_data_enter_modal").modal('toggle'); 
                                    $("#payment_data_enter_modal").modal('show');
                                    $("#total").val($("#sub_total").val());
                                }
                                else{
                                    Swal.fire({
                                        title: 'Unauthorized!',
                                        text: 'Invalid Auth Key!',
                                        icon: 'warning',
                                        showCancelButton: false,
                                        confirmButtonText: 'OK',
                                        }).then((result) => {
                                        if (result.isConfirmed) {
                                        } else {
                                        }
                                    });
                                }
                            },
                            error: function(xhr, status, error) {
                                console.log(error);
                            }
                        });                                            
                    } else {
                    }
                });
            });
        }
        //customer get set functionalities
        $('#customer_phone_number').on("change",function(event){
            var keycode = (event.keyCode ? event.keyCode : event.which);
            var customer_phone_number = $("#customer_phone_number").val();
            //check if customer registered
            $.ajax({
                url: '/search_customer_by_phone_number/'+ customer_phone_number,
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    if(response.status == true){
                        $('#customer_id').val(response.data.customer_id);
                        $('#loyality_no').val(response.data.customer_id);
                        $('#loyality_phone_no').val(customer_phone_number);
                        $('#payment_type').append('<option value="6">Loyality card</option>');
                    }
                    else{
                        swal.fire({
                            title: 'Customer not found',
                            text: "Register?",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonText: 'Yes, Register',
                            cancelButtonText: 'No',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.open('/customer', '_blank');
                            }
                            else{
                                $("#customer_id").val('1');
                            }
                        });
                        $('#payment_type option[value="6"]').remove();
                    }
                },
                error: function(xhr, status, error) {
                    console.log(xhr.responseText);
                }
            });
        });
        function setSaleItemDetails(){
            var voucher_type_arr = $.map($('.voucher_type'), function (el) { return el.value; });
            var serial_number_arr = $.map($('.serial_number'), function (el) { return el.value; });
            var voucher_name_arr = $.map($('.voucher_name'), function (el) { return el.value; });
            var voucher_amount_arr = $.map($('.voucher_amount'), function (el) { return el.value; });
            var issue_date_arr = $.map($('.issue_date'), function (el) { return el.value; });
            var exp_date_arr = $.map($('.exp_date'), function (el) { return el.value; });
            var total = $("#sub_total").val();
            var pos_id = (($("#pos_machine_id").text()).split(":")[1]).trim();
            var user_id = $("#logged_user_id").val();
            var customer_id = $("#customer_id").val();
            var sale_type_id = ($("#sale_type option:selected").val());
            var authorized_by_arr = $.map($('.authorized_by'), function (el) { return el.value; });
            var payment_authorized_by_id = $("#payment_authorized_by_id").val();
            var sale_item_data_arr = [serial_number_arr];
            console.log(voucher_type_arr);
            console.log(serial_number_arr);
            console.log(voucher_name_arr);
            console.log(voucher_amount_arr);
            console.log(issue_date_arr);
            console.log(exp_date_arr);
            console.log(total);
            $.each(serial_number_arr, function (index, value) {
                sale_item_data_arr.push({
                    voucher_type_arr: voucher_type_arr,  
                    serial_number_arr: serial_number_arr,
                    voucher_name_arr: voucher_name_arr,
                    voucher_amount_arr: voucher_amount_arr,
                    issue_date_arr: issue_date_arr,
                    exp_date_arr: exp_date_arr,
                    total: total,
                    pos_id: pos_id,
                    customer_id: customer_id,
                    sale_type_id: sale_type_id,
                    user_id: user_id,
                    payment_authorized_by_id: payment_authorized_by_id,
                });
            });
            return sale_item_data_arr;
        }
        $("#end_sale_btn").click(function(event){
            var sale_item_data_arr = setSaleItemDetails();
            console.log(sale_item_data_arr);
            if(sale_item_data_arr.length < 2){
                Swal.fire({
                    title: 'No Items Entered',
                    text: 'Please enter sale items',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonText: 'OK',
                    }).then((result) => {
                    if (result.isConfirmed) {
                    } else {
                    }
                });
            }
            else{
                if(payment_data_ar.length < 1){
                    Swal.fire({
                        title: 'Payment Data Not Entered',
                        text: 'Please enter payment data',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                        }).then((result) => {
                        if (result.isConfirmed) {
                           
                        } else {
                        }
                    });
                }
                else{
                    storeSale();
                }
                function storeSale(){
                    $.ajax({
                        url: "submit_gift_voucher_sale",
                        type: "POST",
                        data: {
                            sale_item_data_arr: sale_item_data_arr,
                            payment_data_ar:payment_data_ar,
                        },
                        success: function(response) {
                            console.log(response);
                            var sale_id = response.message;
                            swal.fire({
                                title: 'Gift Voucher Sale Stored Successfully',
                                text: "",
                                icon: 'success',
                                showCancelButton: true,
                                confirmButtonText: 'View',
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.open('/view_gift_voucher_sale/'+sale_id, '_blank');
                                    location.reload();
                                }
                                else{
                                    window.location.href = '/gift_voucher_sale'
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            var errorMessage = xhr.responseText;
                            var responseObj = JSON.parse(errorMessage);
                            var errorMessage = responseObj.message;
                            var modifiedErrorMessage = errorMessage.replace(/'(\d+)'/, "'$1'");
                            if(errorMessage == modifiedErrorMessage){
                                swal.fire({
                                title: 'Duplicate entry for serial number',
                                text: "Please enter a valid serial number",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonText: 'Ok',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                    }
                                    else{
                                        
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        //show/hide payment options
        $('#payment_type').on('change',function(e){
            var selected_payment_type = $(this).val();
            console.log(selected_payment_type);
            //if payment type: cash
            if(selected_payment_type == 1){
                $("#bank_div").hide();
                $("#cheque_div").hide();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: credit card
            else if(selected_payment_type == 2){
                $("#bank_div").show();
                $("#cheque_div").hide();
                $("#card_no_div").show();
                $("#payment_method_div").show();
                $("#exp_date_div").show();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: debit card
            else if(selected_payment_type == 3){
                $("#bank_div").show();
                $("#cheque_div").hide();
                $("#card_no_div").show();
                $("#payment_method_div").show();
                $("#exp_date_div").show();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: cheque
            else if(selected_payment_type == 4){
                $("#bank_div").show();
                $("#cheque_div").show();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: gift voucher
            else if(selected_payment_type == 5){
                $("#bank_div").hide();
                $("#cheque_div").hide();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").show();
                $("#loyality_div").hide();
            }
            //if payment type: loyality card
            else if(selected_payment_type == 6){
                $("#bank_div").hide();
                $("#cheque_div").hide();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").hide();
                $("#loyality_div").show();
            }
        });
        //set payment method
        $("#payment_method_visa").on('click',function(e){
            $("#payment_method").val(1);
            $("#payment_method_visa").css('border', '4px solid darkgreen');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_master").on('click',function(e){
            $("#payment_method").val(2);
            $("#payment_method_master").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_amex").on('click',function(e){
            $("#payment_method").val(3);
            $("#payment_method_amex").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_cash_cheque").on('click',function(e){
            $("#payment_method").val(4);
            $("#payment_method_cash_cheque").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_account_pay").on('click',function(e){
            $("#payment_method").val(5);
            $("#payment_method_account_pay").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
        });
        //reset form
        $('#serial_data_enter_modal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });
        //function key press actions
        $(document).on('keydown', function(event) {
            // Check if the key pressed is the "F1" key (key code 112)
            if (event.keyCode === 112) {
                window.open('/items', '_blank');
            }
        });
        
    </script>

<?php $this->endSection() ?>