<?php $this->extend('layouts/master') ?>
<?php $this->section('delivery') ?>
        <!---List: Start --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal"><i class="bi bi-plus-lg fw-bold"></i> New Delivery Entry </button>
                                                   
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Delivery Address</th>
                                            <th class="p-2" scope="col">Delivery Contact No</th>
                                            <th class="p-2" scope="col">Delivery Estimated Shipping Date</th>
                                            <th class="p-2" scope="col">Delivery Estimated Delivery Date</th>
                                            <th class="p-2" scope="col">Delivery Actual Shipping Date</th>
                                            <th class="p-2" scope="col">Delivery Actual Delivery Date</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                            ?>
                                            <tr id="<?php echo $s['id']; ?>">     
                                                <td><?php echo $s['address']; ?></td>
                                                <td><?php echo $s['phone_number']; ?></td>
                                                <td><?php echo date("Y-m-d",strtotime($s['estimated_shipping_date'])); ?></td>
                                                <td><?php echo date("Y-m-d",strtotime($s['estimated_delivery_date'])); ?></td>
                                                <td><?php echo date("Y-m-d",strtotime($s['actual_shipping_date'])); ?></td>
                                                <td><?php echo date("Y-m-d",strtotime($s['actual_delivery_date'])); ?></td>
                                                <td>
                                                        <?php 
                                                            if($s['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['id']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['id']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                </td>  
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="edit" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="delete" type="button" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- List: End --->
        <!--- Insert/update: Start --->
        <div class="modal fade" id="submit_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Add New Delivery Entry</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="add" name="add" action="<?= site_url('submit_delivery') ?>">
                            <input class="form-control" name="id" id="id" placeholder="Delivery ID" hidden value="<?php echo set_value('id');?>">
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="emp_id" class="col-form-label">Employee:</label>
                                    <select class="form-control" name="emp_id" id="emp_id">
                                        <option value="0">--Select Employee--</option>
                                        <?php foreach($employees as $employee){?>
                                            <option value="<?php echo $employee['EmpID'] ;?>" <?php echo set_select('emp_id',$employee['EmpID']);?>><?php echo $employee['EmpName'];?></option>"
                                        <?php }?>
                                    </select>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'emp_id') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="sale_id" class="col-form-label">Sale:</label>
                                    <select class="form-control" name="sale_id" id="sale_id">
                                        <option value="0">--Select Sale--</option>
                                        <?php foreach($sales as $sale){?>
                                            <option value="<?php echo $sale['id'] ;?>" <?php echo set_select('sale_id',$sale['id']);?>><?php echo $sale['id'];?></option>"
                                        <?php }?>
                                    </select>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'sale_id') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">                                
                                <div class="mb-3 col">
                                    <label for="customer_id" class="col-form-label">Customer:</label>
                                    <select class="form-control" name="customer_id" id="customer_id">
                                        <option value="0">--Select Customer--</option>
                                        <?php foreach($customers as $customer){?>
                                            <option value="<?php echo $customer['id'] ;?>" <?php echo set_select('customer_id',$customer['id']);?>><?php echo $customer['first_name'].' '.$customer['last_name'];?></option>"
                                        <?php }?>
                                    </select>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'customer_id') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="phone_number" class="col-form-label">Delivery Contact No:</label>
                                    <input type="tel" class="form-control phone_number" name="phone_number" id="phone_number" placeholder="Enter Delivery Contact No" value="<?php echo set_value('phone_number');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'phone_number') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="address" class="col-form-label">Delivery Address:</label>
                                    <textarea name="address" id="address" cols="30" rows="5" class="form-control" placeholder="Enter Delivery Address" value="<?php echo set_value('address');?>"></textarea>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'address') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="estimated_shipping_date" class="col-form-label">Delivery Estimated Shipping Date:</label>
                                    <input type="date" class="form-control" name="estimated_shipping_date" id="estimated_shipping_date" placeholder="Enter Delivery Estimated Shipping Date" value="<?php echo set_value('estimated_shipping_date');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'estimated_shipping_date') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="estimated_delivery_date" class="col-form-label">Delivery Estimated Delivery Date:</label>
                                    <input type="date" class="form-control" name="estimated_delivery_date" id="estimated_delivery_date" placeholder="Enter Delivery Estimated Delivery Date" value="<?php echo set_value('estimated_delivery_date');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'estimated_delivery_date') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="actual_shipping_date" class="col-form-label">Delivery Actual Shipping Date:</label>
                                    <input type="date" class="form-control" name="actual_shipping_date" id="actual_shipping_date" placeholder="Enter Delivery Actual Shipping Date" value="<?php echo set_value('actual_shipping_date');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'actual_shipping_date') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="actual_delivery_date" class="col-form-label">Delivery Actual Delivery Date:</label>
                                    <input type="date" class="form-control" name="actual_delivery_date" id="actual_delivery_date" placeholder="Enter Delivery Actual Delivery Date" value="<?php echo set_value('actual_delivery_date');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'actual_delivery_date') : '' ?></h6>
                                </div>
                            </div>                           
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit">Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--- Insert/update: End --->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openSubmitModal()
        {
            var submit_modal = $("#submit_modal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                submit_modal.modal('show');
            }
        }
        jQuery(document).ready(function()
         {
            openSubmitModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            Table = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                Table.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    Table.rows().select();        
                } else {
                    Table.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });                        
        //update
        $('body').on('click', '#edit', function () 
        {
            var id = $(this).attr('data-id');
            $.ajax({
                url: 'delivery_edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#submit_modal').modal('show');
                    $('#submit_modal #id').val(res.data.id); 
                    $('#submit_modal #sale_id').val(res.data.sale_id); 
                    $('#submit_modal #customer_id').val(res.data.customer_id);
                    $('#submit_modal #emp_id').val(res.data.emp_id);
                    $('#submit_modal #address').val(res.data.address);
                    $('#submit_modal #phone_number').val(res.data.phone_number);
                    $('#submit_modal #estimated_shipping_date').val(res.data.estimated_shipping_date);
                    $('#submit_modal #estimated_delivery_date ').val(res.data.estimated_delivery_date);
                    $('#submit_modal #actual_shipping_date').val(res.data.actual_shipping_date);
                    $('#submit_modal #actual_delivery_date ').val(res.data.actual_delivery_date);
                },
                    error: function (data) {
                }
            });
        });
        //delete
        $('body').on('click', '#delete', function () 
        {
            var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ id).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'delivery_delete/'+id,
                        async: false,
                        success: function(data){  
                            location.reload()                     
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable tbody #'+ id).remove();
                            }
                        }
                    });
                }
            });          
        });
          //delivery disable
        $('body').on('change', '#disable', function () 
        {
                var id = $(this).attr('data-id');
                //  alert(id);
                $.getJSON('enable_delivery/'+id, function (data) {                
                location.reload();
                        })
        });
        //delivery enable
        $('body').on('change', '#enable', function () 
        {
                var id = $(this).attr('data-id');
                $.getJSON('disable_delivery/'+id, function (data) {
                    location.reload();
                })
        });
        //reset form
        $('#submit_modal').on('hidden.bs.modal', function (e) 
        {
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });
         // prevent multi submit
         document.querySelector('form').addEventListener('submit', function() 
         {
            document.querySelector('#submit').disabled = true;
         });
                  
    </script>
<?php $this->endSection() ?>