<?php $this->extend('layouts/master') ?>

<?php $this->section('tenant') ?>

        <!---List of tenant --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#tenantModal"><i class="bi bi-plus-lg fw-bold"></i>New Tenant </button>                                                  
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Tenant Name</th>
                                            <th class="p-2" scope="col">Tenant BR No</th>
                                            <th class="p-2" scope="col">Tenant City</th>
                                            <th class="p-2" scope="col">Tenant Owner </th>
                                            <th class="p-2" scope="col">Tenant Owner NIC</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                        <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                                
                                            ?>
                                            <tr id="<?php echo $s['TID']; ?>">     
                                                <td><?php echo $s['TName']; ?></td>
                                                <td><?php echo $s['TBRNo']; ?></td>
                                                <td><?php echo $s['TCity']; ?></td>
                                                <td><?php echo $s['TOwnerName']; ?></td>
                                                <td><?php echo $s['TOwnerNIC']; ?></td>
                                                <td>
                                                        <?php 
                                                            if($s['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['TID']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['TID']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                </td>  
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="tenantedit" type="button" data-bs-toggle="modal" data-bs-target="#tenantModal" data-id="<?php echo $s['TID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="tenantdelete" type="button" data-id="<?php echo $s['TID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start tenant data insert and update model -->
        <div class="modal fade" id="tenantModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Tenant Detail Form</h5>
                        <button type="button" id="closefrm" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                    <form id="add_tenant" name="add_tenant" action="<?= site_url('/submit_tenant') ?>" enctype="multipart/form-data"  method="post" accept-charset="utf-8">
                                    <div class="row">
                                        <div class="mb-3 wrapper col">
                                            <div class="box">
                                                <div class="js--image-preview">
                                                <img id="design"  class ="" alt="Ad Picture"  style="width:auto; height:100px;"/>
                                                </div>
                                                <div class="upload-options">
                                                    <label>
                                                        <input type="file" class="image_upload" accept="image/*" name="TLogo" id="TLogo">
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                            <div class="mb-3 col">
                                                 <input type="hidden" class="form-control mb-3" name="TID" id="TID" hidden  value="<?php echo set_value('TID');?>">
                                                <label for="tenant-name" class="col-form-label">Tenant Name:</label>
                                                <input type="text" class="form-control" name="TName"  value="<?php echo set_value('TName');?>" id="TName" placeholder="Enter Tenant Name">
                                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TName') : '' ?></h6>
                                            </div>
                                            <div class="mb-3 col">
                                                <label for="tbr-no" class="col-form-label">Tenant BR No:</label>
                                                <input type="text" class="form-control" name="TBRNo"  value="<?php echo set_value('TBRNo');?>"  id="TBRNo" placeholder="Enter TBRNo">
                                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TBRNo') : '' ?></h6>
                                            </div>
                                    </div>                                                       
                                    <div class="row">
                                        <div class="mb-3 col">
                                            <label for="tenant-addr1" class="col-form-label">Tenant Address1:</label>
                                            <input type="text" class="form-control" name="TAddress1"  value="<?php echo set_value('TAddress1');?>"  id="TAddress1" placeholder="Enter TAddress 1">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="mb-3 col">
                                            <label for="tenant-addr2" class="col-form-label">Tenant Address2:</label>
                                            <input type="text" class="form-control" name="TAddress2"  value="<?php echo set_value('TAddress2');?>" id="TAddress2" placeholder="Enter TAddress 2">
                                            <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TAddress2') : '' ?></h6>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="mb-3 col">
                                            <label for="tenant-city" class="col-form-label">Tenant City:</label>
                                            <input type="text" class="form-control" name="TCity"  value="<?php echo set_value('TCity');?>"  id="TCity" placeholder="Enter the TCity">
                                            <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TCity') : '' ?></h6>
                                        </div>
                                        <div class="mb-3 col">
                                            <label for="tenant-province" class="col-form-label">Tenant Province:</label>
                                            <input type="text" class="form-control"  value="<?php echo set_value('TProvince');?>" name="TProvince" id="TProvince" placeholder="Enter the TProvince">
                                            <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TProvince') : '' ?></h6>
                                        </div>
                                        <div class="mb-3 col">
                                            <label for="tenant-country" class="col-form-label">Tenant Country:</label>
                                            <input type="text" class="form-control"  value="<?php echo set_value('TCountry');?>"  name="TCountry" id="TCountry" placeholder="Enter the TCountry">
                                            <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TCountry') : '' ?></h6>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="mb-3 col">
                                            <label for="City" class="col-form-label">Tenant  Owner Name:</label>
                                            <input type="text" class="form-control"  value="<?php echo set_value('TOwnerName');?>"  name="TOwnerName" id="TOwnerName" placeholder="Enter the TOwnerName">
                                            <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TOwnerName') : '' ?></h6>
                                        </div>
                                    </div>                                
                                    <div class="row">
                                        <div class="mb-3 col">
                                            <label for="recipient-name" class="col-form-label">Tenant NIC:</label>
                                            <input type="text" class="form-control"  value="<?php echo set_value('TOwnerNIC');?>" name="TOwnerNIC" id="TOwnerNIC" placeholder="Enter TOwnerNIC">
                                            <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'TOwnerNIC') : '' ?></h6>
                                        </div>
                                    </div>                       
                                    <!-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button> -->
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>                      
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- end  tenant data insert and update  model -->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openTenantModal()
        {
            var tenant_modal = $("#tenantModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                tenant_modal.modal('show');
            }
        }
        $(document).ready(function() 
        {
            openTenantModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            EmpTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
        //Check All
        function checkAll(o) 
        {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }     
        //update tenant
        $('body').on('click', '#tenantedit', function () 
        {
            var tenant_id = $(this).attr('data-id');
            $.ajax({
                url: '/tenant_edit/'+tenant_id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res);
                    $('#tenantModal').modal('show');
                    $('#add_tenant #TID').val(res.data.TID); 
                    $('#add_tenant #TName').val(res.data.TName); 
                    $('#add_tenant #TBRNo').val(res.data.TBRNo); 
                    $('#add_tenant #TAddress1').val(res.data.TAddress1);
                    $('#add_tenant #TAddress2').val(res.data.TAddress2);
                    $('#add_tenant #TCity').val(res.data.TCity);
                    $('#add_tenant #TProvince ').val(res.data.TProvince);
                    $('#add_tenant #TCountry').val(res.data.TCountry); 
                    $('#add_tenant #TOwnerName').val(res.data.TOwnerName); 
                    $('#add_tenant #TOwnerNIC').val(res.data.TOwnerNIC);
                    $('#add_tenant #design ').attr('src','/uploads/tenantImg/'+ res.data.TLogo);
                },
                    error: function (data) {
                }
            });
        });
         //delete tenant
        $('body').on('click', '#tenantdelete', function ()
        {
                var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {

                if (result.isConfirmed) {
                    $.get('tenant_delete/'+id, function (data) {
                if(data.error)
                    // alert('Can not delete, this record has related information');    
                    swal.fire({
                        title: 'Can not delete',
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
		            });
                else
                    swal.fire({
                        title: 'Deleted',
                        text: "This record has deleted Successfully!",
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonText: 'OK',                       
                    }).then((result) => {
                        location.reload();
                        $('#viewtable tbody #'+ id).remove();
                    });
                  
                      })
                }
                
            });          
        });

        //reset form
        $('#bankModal').on('hidden.bs.modal', function (e) 
        {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });
        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() 
        {
            document.querySelector('#submit').disabled = true;
        }); 
         //tenant disable
        $('body').on('change', '#disable', function () 
        {
                var id = $(this).attr('data-id');
                //  alert(id);
                $.getJSON('enable_tenant/'+id, function (data) {                
                location.reload();
                        })
        });
        //tenant enable
        $('body').on('change', '#enable', function () 
        {
                var id = $(this).attr('data-id');
                $.getJSON('disable_tenant/'+id, function (data) {
                    location.reload();
                })
        });                
    </script>
<?php $this->endSection() ?>