<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Functionalities extends Migration
{
    public function up()
    {
        //Create Functionalities Table
        $this->forge->addField([
            'FID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'FName' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],   
            'FCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'FCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'FUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'FUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'FDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'FDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('FID');
        $this->forge->createTable('functionalities');
    }

    public function down()
    {
        //Drop Functionalities Table
        $this->forge->dropTable('functionalities');
    }
}
