<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Itemcategory extends Migration
{
    public function up()
    {
        //Create Item Category Table
        $this->forge->addField([
            'ICID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ICName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICLink' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICParentID' => [
                'type' => 'varchar',
                'constraint' => 255,
                'default' => 0,
            ],
            'ICLevel' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICParentCatName' => [
                'type' => 'varchar',
                'constraint' => 255,
                'default' => 0,
            ],
            'ICCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'ICUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'ICDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive_individually: 2,inactive_by_parent:3',
            ],
            'delete_flag' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('ICID');
        $this->forge->createTable('itemcategory');
    }

    public function down()
    {
        //Drop Item Category Table
        $this->forge->dropTable('itemcategory');
    }
}
