<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Bin extends Migration
{
    public function up()
    {
        //Create Bin Table
        $this->forge->addField([
            'BinID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'BinName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ShelfID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BinSpace' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BinCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BinCreaterBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'BinUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BinCreaterBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'BinDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BinDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'BinStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('BinID');
        $this->forge->createTable('bin');
    }

    public function down()
    {
        //Drop Bin Table
        $this->forge->dropTable('bin');
    }
}
