<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class TempReceivingdetails extends Migration
{
    public function up()
    {
         //Create Receiving details Table
         $this->forge->addField([
            'RDID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'CartID' => [
                'type' => 'TEXT',
            ],
            'RID' => [
                'type' => 'INT',
                'constraint' => 255,
            ],
            'ItemID' => [
                'type' => 'INT',
            ],
            'RDIsSerialized' => [
                'type' => 'INT',
            ],
            'RDLine' => [
                'type' => 'INT',
            ],
            'RDQty' => [
                'type' => 'INT'
            ],
            'RDUnit' => [
                'type' => 'varchar',
                'constraint' => 30,
            ],
            'RDCostPrice' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RDSellingPrice' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RDMFD' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'RDEXP' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'RDiscount' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RAmount' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RDCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('RDID');
        $this->forge->createTable('temp_receivingdetails');
    }

    public function down()
    {
          //Drop receiving Table
          $this->forge->dropTable('temp_receivingdetails');
    }
}
