<?php

    namespace App\Controllers\Api;

    use CodeIgniter\RESTful\ResourceController;
    use CodeIgniter\API\ResponseTrait;
    use App\Models\EmployeeModel;

    class Employee extends ResourceController
    {
        use ResponseTrait;
      
        public function index()
        {
            $EmployeeModel = new EmployeeModel();
            $Employee['Employees'] = $EmployeeModel->orderBy('EmpID', 'DESC')->findAll();
            return $this->respond($Employees);
        }
        // create Employee
        public function create() {
            $model = new EmployeeModel();
            $data = [
                'EmpID' => $this->request->getPost('EmpID'),
                'EmpImg' => $this->request->getPost('EmpImg'),
                'EmpName' => $this->request->getPost('EmpName'),
                'EmpDesignation' => $this->request->getPost('EmpDesignation'),
                'EmpDateofBirth' => $this->request->getPost('EmpDateofBirth'),
                'EmpNICNo' => $this->request->getPost('EmpNICNo'),
                'EmpAddressLine1' => $this->request->getPost('EmpAddressLine1'),
                'EmpAddressLine2' => $this->request->getPost('EmpAddressLine2'),
                'EmpCity' => $this->request->getPost('EmpCity'),
                'EmpProvince' => $this->request->getPost('EmpProvince'),
                'EmpCountry' => $this->request->getPost('EmpCountry'),
                'EmpContactNo' => $this->request->getPost('EmpContactNo'),
                'EmpEmail' => $this->request->getPost('EmpEmail'),
                'EmpAltContactPerson' => $this->request->getPost('EmpAltContactPerson'),
                'EmpAltNICNo' => $this->request->getPost('EmpAltNICNo'),
                'EmpAltContactNo' => $this->request->getPost('EmpAltContactNo'),
                'EmpCreatedAt' => $this->request->getPost('EmpCreatedAt'),
                'EmpUpdatedAt' => $this->request->getPost('EmpUpdatedAt'),
                'EmpDeletedAt' => $this->request->getPost('EmpDeletedAt'),
                'EmpStatus' => $this->request->getPost('EmpStatus')
            ];
            $model->insert($data);
            $response = [
                'status'   => 201,
                'error'    => null,
                'messages' => [
                    'success' => 'Employee created successfully'
                ]
            ];
            return $this->respondCreated($response);
        }
        // single Employee
        public function show($id = null){
            $model = new EmployeeModel();
            $data = $model->where('EmpID', $id)->first();
            if($data){
                return $this->respond($data);
            }else{
                return $this->failNotFound('No Employee found');
            }
        }        
        // update
        public function update($id = null){
            $model = new EmployeeModel();
            $id = $this->request->getVar('id');
            $data = [
                'EmpID' => $this->request->getPost('EmpID'),
                'EmpImg' => $this->request->getPost('EmpImg'),
                'EmpName' => $this->request->getPost('EmpName'),
                'EmpDesignation' => $this->request->getPost('EmpDesignation'),
                'EmpDateofBirth' => $this->request->getPost('EmpDateofBirth'),
                'EmpNICNo' => $this->request->getPost('EmpNICNo'),
                'EmpAddressLine1' => $this->request->getPost('EmpAddressLine1'),
                'EmpAddressLine2' => $this->request->getPost('EmpAddressLine2'),
                'EmpCity' => $this->request->getPost('EmpCity'),
                'EmpProvince' => $this->request->getPost('EmpProvince'),
                'EmpCountry' => $this->request->getPost('EmpCountry'),
                'EmpContactNo' => $this->request->getPost('EmpContactNo'),
                'EmpEmail' => $this->request->getPost('EmpEmail'),
                'EmpAltContactPerson' => $this->request->getPost('EmpAltContactPerson'),
                'EmpAltNICNo' => $this->request->getPost('EmpAltNICNo'),
                'EmpAltContactNo' => $this->request->getPost('EmpAltContactNo'),
                'EmpCreatedAt' => $this->request->getPost('EmpCreatedAt'),
                'EmpUpdatedAt' => $this->request->getPost('EmpUpdatedAt'),
                'EmpDeletedAt' => $this->request->getPost('EmpDeletedAt'),
                'EmpStatus' => $this->request->getPost('EmpStatus')
            ];
            $model->update($id, $data);
            $response = [
                'status'   => 200,
                'error'    => null,
                'messages' => [
                'success' => 'Employee updated successfully'
                ]
            ];
            return $this->respond($response);
        }
        // delete
        public function delete($id = null){
            $model = new EmployeeModel();
            $data = $model->where('EmpID', $id)->delete($id);
            if($data){
                $model->delete($id);
                $response = [
                    'status'   => 200,
                    'error'    => null,
                    'messages' => [
                        'success' => 'Employee successfully deleted'
                    ]
                ];
                return $this->respondDeleted($response);
            }else{
                return $this->failNotFound('No Employee found');
            }
        }
    }

?>