<?php
namespace App\Controllers;
use App\Models\CardPromotionModel;
use App\Models\UserModel;
use App\Controllers\BaseController;
use App\Models\BanksModel;

class CardPromotionController extends BaseController
{    
    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->cardPromoModel = new CardPromotionModel();
        $this->bankModel = new BanksModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
    } 
    // insert data
    public function submit() {
        $validation = $this->validate([
            'amount' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Amount is required',
                ],
            ],
            'bank' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Bank  is required',
                ],
            ],
            'start_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Started Date is required',
                ],
            ],
            'end_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'End Date is required',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        $session = session();
        if($validation){   
            if($id == ''){  //insert card promotion details      
                $data = [
                    'bank_name' => $this->request->getVar('bank'),
                    'amount' => $this->request->getVar('amount'),
                    'start_date' => $this->request->getVar('start_date'),
                    'end_date' => $this->request->getVar('end_date'),
                    'delete_flag' => '0',
                    'created_at'=>date('Y-m-d H:i:s'),
                ];
                $this->cardPromoModel->insertData($data);
                 // Set the success flash message
          $session->setFlashdata('title', 'Saved');
          $session->setFlashdata('message', 'Card promotion saved successfully.');
            }
            else{      //update card promotion details
                $data = [
                    'bank_name' => $this->request->getVar('bank'),
                    'amount' => $this->request->getVar('amount'),
                    'start_date' => $this->request->getVar('start_date'),
                    'end_date' => $this->request->getVar('end_date'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];        
                $this->cardPromoModel->updateData($id, $data);
                 // Set the success flash message
          $session->setFlashdata('title', 'Saved');
          $session->setFlashdata('message', 'Card promotion update successfully.');
            }
             return $this->response->redirect(site_url('/card_promotion'));
                 }
        else    {
            $user_info = getUserInfo();
            $records['card_promotion']= $this->cardPromoModel->getIndexData();
            $banks=$this->bankModel->getIndexNBankData();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Card_promotion',
                'link' => 'card_promotion',
                'sources' => $records,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,
                'banks'=>$banks,
            );
            return view('card_promotion', $data);
            
             }
    }
    //get single data
    public function singleData($id = null) {
        $data=$this->cardPromoModel->getSingleData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    public function index()
    {
        $user_info = getUserInfo();
        $records['card_promotion']= $this->cardPromoModel->getIndexData();
        $banks=$this->bankModel->getIndexNBankData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Card_promotion',
            'link' => 'card_promotion',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
            'banks'=>$banks,
        );
        return view('card_promotion', $data);
    }
    // delete
    public function delete($id = null){
        $data = [
            'deleted_at' =>  $this->now,
            'delete_flag' => '1',
        ];
        $this->cardPromoModel->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/card_promotion'));
    } 
}
