<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\EmployeeModel;
use App\Models\UserModel;
use App\Models\UserRoleModel;
use App\Models\CommonModel;
class EmployeeController extends BaseController
{

    public function __construct(){    
        $this->employee = new EmployeeModel();  
        $this->common = new CommonModel();           
        $this->userRolemodel = new UserRoleModel(); 
        $this->userModel = new UserModel();   
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
    }

    public function index()
    {
        $emp['employee']= $this->employee->getIndexData();
        $ur['User Roles'] = $this->userRolemodel->getUrolesIndexData();
        $loggedUserID = session()->get('loggedUser');
        $user_info = $this->userModel->getSingleUserData($loggedUserID);
        $has_errors = 'false';
        $userchecked = '0';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Employees',
            'link' => 'employees',
            'sources' => $emp,
            'userroles' =>$ur,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
            'userchecked' => $userchecked,
        );
        return view('employees', $data);
    }

    //create new employee
    public function save()
    {
        $userCheckId=$this->request->getVar('Userchecked');
        $user_info = getUserInfo();   
        if($this->request->getVar('Userchecked')=='1'){
            $validation = $this->validate([
                'EmpName' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter name',
                    ],
                ],
                'EmpDesignation' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter designation',
                    ],
                ],
                // 'EmpEmail' => [
                //     'rules'=>[
                //         'rules'=>'required',
                //         // 'is_unique[employee.EmpEmail,EmpID,{EmpID}]',
                //         'valid_email',
                //     ],
                //     'errors'=>[
                //         'required'=>'Please enter email address',
                //         'valid_email'=>'Please enter valid email',
                //         // 'is_unique'=>'This Email already exists!'
                //     ],
                // ],
             
                // 'EmpContactNo' => [
                //     'rules'=>[
                //          'rules'=>'required',
                //          //'regex_match[/^[0-9]{10}$/]',
                //         //  'is_unique[employee.EmpContactNo,EmpID,{EmpID}]',
                //     ],
                    
                //    'errors'=>[
                //     'required'=>'Please enter contact number',
                //     // 'is_unique'=>'This Contact No already exists!',
                //     //'regex_match' => 'Contact Number must be a valid 10-digit mobile number.'
                // ],
                // ],
                // 'EmpDateofBirth' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter date of birth',
                //     ],
                // ],
                // 'EmpCity' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter city',
                //     ],
                // ],
                // 'EmpProvince' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter province',
                //     ],
                // ],
                // 'EmpCountry' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter country',
                //     ],
                // ],
                // 'EmpNICNo' => [
                //     'rules'=>[
                //         'rules'=>'required',
                //         // 'is_unique[employee.EmpNICNo,EmpID,{EmpID}]',
                //         'regex_match[/^[0-9]{9}[vVxX]$/]'
                //     ],
                //     'errors'=>[
                //         'required'=>'Please enter NIC numbber',
                //         'regex_match' => 'Not a valid NIC number.',
                //         'is_unique'=>'This NIC already exists!',
                //     ],
                // ],
                // 'username' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter name',
                //     ],
                // ],
                // 'password' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter password',
                //     ],
                // ],
                // 'cPassword' => [
                //     'rules'=> 'required|matches[password]',
                //     'errors'=>[
                //         'required'=>'Please enter confirm password',
                //         'matches'=>'Confirm password should match with password',
                //     ],
                // ],
                // 'RoleID' => [
                //     'rules'=>'required',
                //     'errors'=>[
                //         'required'=>'Please enter  user role',
                //     ],
                // ],
                // 'authkey'=>[
                //     'rules'=>'required|is_unique[user.AuthKey,UserID,{UserID}]',
                //     'errors'=>[
                //         'required'=>'AuthKey is required',
                //         'is_unique'=>'This is already exists!',
                //     ],
                // ]

            ]);
        }
        else{
            $validation = $this->validate([
                'EmpName' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter name',
                    ],
                ],
                'EmpDesignation' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter designation',
                    ],
                ],
            //     'EmpEmail' => [
            //         'rules'=>[
            //             'rules'=>'required',
            //             // 'is_unique[employee.EmpEmail,EmpID,{EmpID}]',
            //             'valid_email',
            //         ],
            //         'errors'=>[
            //             'required'=>'Please enter email address',
            //             'valid_email'=>'Please enter valid email',
            //             // 'is_unique'=>'This Email already exists!'
            //         ],
            //     ],
             
            //     'EmpContactNo' => [
            //         'rules'=>[
            //              'rules'=>'required',
            //              'regex_match[/^[0-9]{10}$/]',
            //             //  'is_unique[employee.EmpContactNo,EmpID,{EmpID}]',
            //         ],
                    
            //        'errors'=>[
            //         'required'=>'Please enter contact number',
            //         // 'is_unique'=>'This Contact No already exists!',
            //         'regex_match' => 'Contact Number must be a valid 10-digit mobile number.'
            //     ],
            //     ],
            //     'EmpDateofBirth' => [
            //         'rules'=>'required',
            //         'errors'=>[
            //             'required'=>'Please enter date of birth',
            //         ],
            //     ],
            //     'EmpCity' => [
            //         'rules'=>'required',
            //         'errors'=>[
            //             'required'=>'Please enter city',
            //         ],
            //     ],
            //     'EmpProvince' => [
            //         'rules'=>'required',
            //         'errors'=>[
            //             'required'=>'Please enter province',
            //         ],
            //     ],
            //     'EmpCountry' => [
            //         'rules'=>'required',
            //         'errors'=>[
            //             'required'=>'Please enter country',
            //         ],
            //     ],
            //     'EmpNICNo' => [
            //         'rules'=>[
            //             'rules'=>'required',
            //             // 'is_unique[employee.EmpNICNo,EmpID,{EmpID}]',
            //             'regex_match[/^[0-9]{9}[vVxX]$/]'
            //         ],
            //         'errors'=>[
            //             'required'=>'Please enter NIC numbber',
            //             'regex_match' => 'Not a valid NIC number.',
            //             // 'is_unique'=>'This NIC already exists!',
            //         ],
            //     ],
            ]);
        }

        $id = $this->request->getVar('EID');
        $session = session();
        if($validation){ 
                if($id== ''){  //insert part
                    $data = [
                        'EmpName' => $this->request->getVar('EmpName'), 
                        'EmpDesignation'=>$this->request->getVar('EmpDesignation'),
                        'EmpEmail' => $this->request->getVar('EmpEmail'),
                        'EmpContactNo' =>$this->request->getVar('EmpContactNo'),
                        'EmpDateofBirth' =>$this->request->getVar('EmpDateofBirth'),
                        'EmpAltContactPerson' => $this->request->getVar('EmpAltContactPerson'),
                        'EmpAddressLine1' =>$this->request->getVar('EmpAddressLine1'),
                        'EmpAddressLine2' => $this->request->getVar('EmpAddressLine2'),
                        'EmpCity' => $this->request->getVar('EmpCity'),
                        'EmpProvince' =>$this->request->getVar('EmpProvince'),
                        'EmpCountry' => $this->request->getVar('EmpCountry'),
                        'EmpNICNo' => $this->request->getVar('EmpNICNo'),
                        'EmpAltNICNo' => $this->request->getVar('EmpAltNICNo'),
                        'EmpAltContactNo' => $this->request->getVar('EmpAltContactNo'),
                        'delete_flag' => '0',
                        'EmpCreatedAt' => date('Y-m-d H:i:s'),
                        'EmpCreatedBy' => $user_info->UserID,
                        
                    ];
                    if(!empty($_FILES['EmpImg']['name'])){ 
                        $imageFile = $this->request->getFile('EmpImg');
                        $imageFile->move('../public/uploads/empImg');
                        $imgDetail =$_FILES['EmpImg'];
                        $data['EmpImg']= $imgDetail ['name'];
                    }    
                     //set trans status
                // $transaction_status = false;
                // //---begin transaction---
                // $this->db->transBegin();
                    if( $this->employee->insertEmpData($data)){
                        // if ($this->db->transStatus() === FALSE){
                        //     //---rollback transaction
                        //     $this->db->transRollback();
                        //     $transaction_status = false;
                        //        // Set the success flash message
                        //     $session->setFlashdata('title', 'Error');
                        //     $session->setFlashdata('icon', 'warning');
                        //     $session->setFlashdata('message', 'Something Went wrong.');  
                        // }
                        // else{
                        //     //---commit transaction
                        //     $this->db->transCommit();
                        //     $transaction_status = true;
                        //    // Set the success flash message
                        //     $session->setFlashdata('title', 'Saved');
                        //     $session->setFlashdata('icon', 'success');
                        //     $session->setFlashdata('message', 'Employee  details saved successfully.'); 
                        // } 
                        $id =  $this->employee->insertID();                               
                      if($userCheckId){ //check whether checkbox is clicked or not 
                        $userData=[
                            'UserName'=>$this->request->getVar('username'),
                            'UserPassword' => $this->request->getVar('password'),
                            'UserRole' => $this->request->getVar('RoleID'), 
                            'EmpID'=>$id , 
                            'AuthKey'=>$this->request->getVar('authkey'),
                            'UserCreatedAt'=>date('Y-m-d H:i:s'),
                            'UserCreatedBy' => $user_info->UserID,
                            'delete_flag'=>'0'
                    ];    
                       if($this->request->getVar('UserID')){
                        $uid = $this->request->getVar('UserID');
                        $this->userModel->updateUser($userData,$uid);  
                         // Set the success flash message
                         $session->setFlashdata('title', 'Saved');
                         $session->setFlashdata('message', 'Employee and User details updated successfully.');  
                       } 
                       else
                       {
                        //set trans status
                        $transaction_status = false;
                        //---begin transaction---
                        $this->db->transBegin();
                        $this->userModel->insertUserData( $userData);   //  insert user data 
                        if ($this->db->transStatus() === FALSE){
                            //---rollback transaction
                            $this->db->transRollback();
                            $transaction_status = false;
                               // Set the success flash message
                            $session->setFlashdata('title', 'Error');
                            $session->setFlashdata('icon', 'warning');
                            $session->setFlashdata('message', 'Something Went wrong.');  
                        }
                        else{
                            //---commit transaction
                            $this->db->transCommit();
                            $transaction_status = true;
                           // Set the success flash message
                            $session->setFlashdata('title', 'Saved');
                            $session->setFlashdata('icon', 'success');
                            $session->setFlashdata('message', 'Employee and User details saved successfully.'); 
                        }          
                       }                    
                        
                       if ($this->db->transStatus() === FALSE){
                        //---rollback transaction
                        $this->db->transRollback();
                        $transaction_status = false;
                           // Set the success flash message
                        $session->setFlashdata('title', 'Error');
                        $session->setFlashdata('icon', 'warning');
                        $session->setFlashdata('message', 'Something Went wrong.');  
                    }
                    else{
                        //---commit transaction
                        $this->db->transCommit();
                        $transaction_status = true;
                       // Set the success flash message
                        $session->setFlashdata('title', 'Saved');
                        $session->setFlashdata('icon', 'success');
                        $session->setFlashdata('message', 'Employee  details saved successfully.'); 
                    }                                 

                    return $this->response->redirect(site_url('/employees'));
                      }
                      else{
                        return $this->response->redirect(site_url('/employees'));
                      }
                    }
                    // // failure
                    // else
                    // {	
                    //     echo json_encode(array('success'=>false,
                    //     $data['EmpName']));
                    // }
                }
                else{  //update part
                $id = $this->request->getVar('EmpId');
                $uid = $this->request->getVar('UserID');
                $data = [
                    'EmpName' => $this->request->getVar('EmpName'),
                    'EmpDesignation'  => $this->request->getVar('EmpDesignation'),
                    'EmpEmail'  => $this->request->getVar('EmpEmail'),
                    'EmpContactNo'  => $this->request->getVar('EmpContactNo'),
                    'EmpDateofBirth'  => $this->request->getVar('EmpDateofBirth'),
                    'EmpAltContactPerson' => $this->request->getVar('EmpAltContactPerson'),
                    'EmpAddressLine1'  => $this->request->getVar('EmpAddressLine1'),
                    'EmpAddressLine2'  => $this->request->getVar('EmpAddressLine2'),
                    'EmpCity'  => $this->request->getVar('EmpCity'),
                    'EmpProvince'  => $this->request->getVar('EmpProvince'),
                    'EmpCountry'  => $this->request->getVar('EmpCountry'),
                    'EmpNICNo' => $this->request->getVar('EmpNICNo'),
                    'EmpAltNICNo'  => $this->request->getVar('EmpAltNICNo'),
                    'EmpAltContactNo'  => $this->request->getVar('EmpAltContactNo'),
                    'EmpUpdatedAt' => date('Y-m-d H:i:s'),
                    'EmpUpdatedBy' => $user_info->UserID,
                    'EmpID'=>$id
                ];
                if(!empty($_FILES['EmpImg']['name'])){ 
                    $imageFile = $this->request->getFile('EmpImg');
                    $imageFile->move('../public/uploads/empImg');
                    $imgDetail =$_FILES['EmpImg'];
                    $data['EmpImg']= $imgDetail ['name'];
                }
                $this->employee->updateEmp($data,$id);
                 // Set the success flash message
                 $session->setFlashdata('title', 'Saved');
                 $session->setFlashdata('message', 'Employee and   details updated successfully.');
                $userId = $this->request->getVar('UserID');
                $userData=[
                    'UserName'=>$this->request->getVar('username'),
                    'UserPassword' => $this->request->getVar('password'),
                    'UserRole' => $this->request->getVar('RoleID'), 
                    'EmpID'=>$id ,
                    'AuthKey'=>$this->request->getVar('authkey'),
                    'UserID'=>$userId,
                    'UserUpdatedAt'=> date('Y-m-d H:i:s'),
                    'UserUpdatedBy' => $user_info->UserID,
            ];
            if($this->request->getVar('UserID')){
                $uid = $this->request->getVar('UserID');    
                $this->userModel->updateUser($userData,$uid,$id); 
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', 'User and employee details updated successfully.');   
               } 
               else{
                $this->userModel->insertUserData( $userData);   //  insert user data
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', 'User  details saved successfully.'); 
               }     
                    // $this->userModel->updateUser($userData,$uid);    
                return $this->response->redirect(site_url('/employees'));
                }
             }
        else{
            $emp['empData'] = $this->employee->getIndexData();
            $ur['User Roles']=$this->userRolemodel->getUrolesIndexData();
            $loggedUserID = session()->get('loggedUser');
            $user_info = $this->userModel->getSingleUserData($loggedUserID);
            $has_errors = 'true';
            $userchecked  = '0';
            if($this->request->getVar('Userchecked')=='1'){
                $userchecked  = '1';
            }else{
                $userchecked  = '0';
            }
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Employees',
                'link' => 'employees',
                'sources' => $emp,
                'userroles' =>$ur,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'userchecked'  =>  $userchecked,
                'validation'=>$this->validator,
            );
            return view('employees', $data);
            }
    }
    //get single data
    public function singleData($id = null)
     {
        $data2=$this->userModel->getSingleEmpData($id);
        if($data2){
            $data=$this->employee->getUserEmployeeJoinData($id);
        }
        else{
             $data=$this->employee->getSingleEmpData($id);
        }
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            if($data){
                echo json_encode(array("status" => true , 'data' => $data));
            }else{
                echo json_encode(array("status" => false));
            }
         }
    }
    // delete employee
    public function delete($id = null)
    {
        $user_info = getUserInfo();   
        $has_user_info = $this->common->checkForeignKeyConstraints("user","EmpID",$id,"delete_flag",0);
        $has_delivery_info = $this->common->checkForeignKeyConstraints("delivery","emp_id",$id,"delete_flag",0);
        $now = date("Y-m-d H:i:s");
          //define message
          $msg_prefix = 'This employee has ';
          $msg_user_info = 'user information';
          $msg_delivery_info = ' delivery information ';
          $msg = '';
          if($has_user_info && $has_delivery_info ){
           $msg = $msg_prefix.$msg_user_info.','.$msg_delivery_info;
       }
       else{
           if($has_user_info && !($has_delivery_info)){
               $msg = $msg_prefix.$msg_user_info;
           }
           else if($has_delivery_info && !($has_user_info)){
               $msg = $msg_prefix.$msg_delivery_info;
           }
       }
        $data = [
            'EmpDeletedAt' => $now,
            'EmpDeletedBy' => $user_info->UserID,
            'delete_flag' => '1',
        ];

        if($has_user_info || $has_delivery_info ){
            return $this->response->setJSON([
                'error' => true,
                'message' => $msg
            ]);
        }
        else{
            $this->employee->deleteEmp($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }

        // $this->employee->deleteEmp($id, $data);
        // if($this->userModel->getSingleEmpData($id)){
        //     $datau=[
        //         'UserDeletedAt'=>$now,
        //         'UserDeletedBy' => $user_infoa->UserID,
        //         'delete_flag' => '1',  
        //     ];
        //     $this->userModel->deleteUser($id, $datau);
        // }
        // return $this->response->setJSON([
        //     'error' => false,
        //     'message' => 'Successfully deleted!'
        // ]);
        return $this->response->redirect(site_url('/employees'));
    }

       // employee disable
       public function disableemployee($id = null)
       {
           $data = [
               'current_status' => '2'
           ];

           if($this->employee->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
       // employee enable
       public function enableemployee($id = null)
       {
           $data = [
               'current_status' => '1'
           ];

           if($this->employee->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
}