<?php

namespace App\Controllers;
use App\Models\GiftCardModel;
use App\Models\UserModel;
use App\Controllers\BaseController;
use App\Models\CommonModel;
use App\Models\BanksModel;
use App\Models\ItemsModel;
use App\Models\SalesModel;
use App\Models\PaymentModel;
use Dompdf\Dompdf;

class GiftCardController  extends BaseController
{    
    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->giftCardModel = new GiftCardModel();
        $this->now = date("Y-m-d H:i:s");
        $this->common = new CommonModel();
        $this->bank = new BanksModel();   
        $this->items = new ItemsModel();  
        $this->sale = new SalesModel();    
        $this->payment = new PaymentModel();
        helper(['url','form','app']);
    }
    // insert data
    public function submit() 
    {
        $validation = $this->validate([
            'issue_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter issue date',
                ],
            ],
            'exp_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter expire date',
                ],
            ],
            'amount' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter amount',
                ],
            ],
            'serial_number' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter serial number',
                ],
            ],

        ]);
        $id = $this->request->getVar('id');
        $session = session();
        if($validation)
        {
                if($id == ''){  //insert gift card detail
                $data = [
                    'giftcard_issue_date' => $this->request->getVar('issue_date'),
                    'giftcard_expire_date'  => $this->request->getVar('exp_date'),
                    'giftcard_issued_by'  => $this->request->getVar('issued_name'),
                    'amount'=>$this->request->getVar('amount'),
                    'serial_number'=>$this->request->getVar('serial_number'),
                    'delete_flag' => '0',
                    'created_at' => date('Y-m-d H:i:s'),
                ];
                 $this->giftCardModel->insertData($data);
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', ' Gift card  details saved successfully.');
             }
            else{   //update gift card details
                $data = [
                    'giftcard_issue_date' => $this->request->getVar('issue_date'),
                    'giftcard_expire_date'  => $this->request->getVar('exp_date'),
                    'giftcard_issued_by'  => $this->request->getVar('issued_name'),
                    'amount'=>$this->request->getVar('amount'),
                    'serial_number'=>$this->request->getVar('serial_number'),
                    'updated_at'=>date('Y-m-d H:i:s'),
                ];
             $this->giftCardModel->updateData($id, $data);
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', ' Gift card  details updated successfully.');
            }
            return $this->response->redirect(site_url('/gift_card'));
         }
        else{
            $user_info = getUserInfo();
            $gft['Gift_card']=$this->giftCardModel->getIndexData();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Gift_card',
                'link' => 'gift_card',
                'sources' => $gft,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('gift_card', $data);
        }
    }
   
    //get single data
    public function singleData($id = null) 
    {
        $data=$this->giftCardModel->getSingleData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    public function index()
    {
        $user_info = getUserInfo();
        $gft['Gift_card']=$this->giftCardModel->getIndexData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Gift_card',
            'link' => 'gift_card',
            'sources' => $gft,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('gift_card', $data);
    }
    
    // delete
    public function delete($id = null)
    {
        $data = [
            'deleted_at' =>  $this->now,
            'delete_flag' => '1',
        ];
        $this->giftCardModel->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/gift_card'));
    } 
    //check voucher validity
    public function checkVoucherValidity($gift_card,$total_amount)
    {
        $gift_card_data = $this->giftCardModel->checkVoucherValidity($gift_card,$total_amount);
        return $this->response->setJSON([
            'error' => false,
            'voucher_validity' => $gift_card_data['voucher_validity'],
            'expire_status' => $gift_card_data['expire_status'],
            'is_sufficient' => $gift_card_data['is_sufficient'],
            'amount' => $gift_card_data['amount'],
        ]);
    }
    //gift voucher sale
    public function giftVoucherSaleIndex()
    {      
        $user_info = getUserInfo();   
        $has_errors = 'false';
        $banks = $this->bank->getIndexNBankData();
        $items = $this->items->getItemIndexData();
        $loyalty_percentage = ($this->common->getSpecificColumnValueByGivenColumnName('masterconfig','id','loyalty_percentage',1,'delete_flag',0))->loyalty_percentage;
        $tax = ($this->common->getSpecificColumnValueByGivenColumnName('masterconfig','id','tax',1,'delete_flag',0))->tax;
        $data = array(
            'visa_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/visa.png'),
            'master_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/master.png'),
            'amex_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/amex.png'),
            'cash_cheque_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/cash_cheque.png'),
            'account_pay_logo'    => $this->imageToBase64(ROOTPATH . '/public/img/account_pay.png'),
            'banks' => $banks,
            'loyalty_percentage' => $loyalty_percentage,
            'tax' => $tax,
            'breadcrumbs' => 'true',
            'title' => 'Gift Voucher Sale',
            'link' => 'gift_voucher_sale',
            'sources' => $items,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('gift_voucher_sale', $data);
    }
    private function imageToBase64($path)
     {
        $path = $path;
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        return $base64;
    }
    //insert/update data
    public function giftVoucherSaleSubmit() 
    {
        $user_info = getUserInfo();   
        $id = $this->request->getVar('id');
        $all_sale_item_data_arr = ($this->request->getVar('sale_item_data_arr'))[1];
        $payment_data_ar = ($this->request->getVar('payment_data_ar'));
        //set sale data
        $sale_data = [
            'pos_id'  => $all_sale_item_data_arr['pos_id'],
            'user_id'  => $all_sale_item_data_arr['user_id'],
            'customer_id'  => $all_sale_item_data_arr['customer_id'],
            'sale_type_id'  => $all_sale_item_data_arr['sale_type_id'],
            'total_amount'  => $all_sale_item_data_arr['total'],
            'created_at' => date('Y-m-d H:i:s'),
        ];
        //insert sale data
        $sale_data_insert_query = $this->sale->insertData($sale_data);
        if ($sale_data_insert_query == true) {
            //get sale id
            $last_inserted_sale_id = $this->sale->insertID();
            //set gift voucher data
            for($i=0;$i<count($all_sale_item_data_arr['voucher_name_arr']);$i++){
                if($all_sale_item_data_arr['voucher_type_arr'][$i] == "e_voucher")
                    $voucher_type = 0;
                if($all_sale_item_data_arr['voucher_type_arr'][$i] == "normal_voucher")
                    $voucher_type = 1;
                $gift_card_data[$i] = [
                    'sale_id'  => $last_inserted_sale_id,
                    'voucher_type'  => $voucher_type,
                    'gift_card_name'  => $all_sale_item_data_arr['voucher_name_arr'][$i],
                    'giftcard_issue_date'  => $all_sale_item_data_arr['issue_date_arr'][$i],
                    'giftcard_expire_date'  => $all_sale_item_data_arr['exp_date_arr'][$i],
                    'giftcard_issued_by'  => $user_info->UserID,
                    'serial_number'  => $all_sale_item_data_arr['serial_number_arr'][$i],
                    'amount'  => $all_sale_item_data_arr['voucher_amount_arr'][$i],
                    'is_used' => 0,
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by'  => $user_info->UserID,
                ];
                //insert gift voucher data
                $gift_card_data_insert_query = $this->giftCardModel->insertData($gift_card_data[$i]);
            }
        }
        if ($gift_card_data_insert_query == true) {
            if($payment_data_ar != null){
                //set payment data
                for($i=0;$i<count($payment_data_ar);$i++){
                    $customer_id = $all_sale_item_data_arr['customer_id'];
                    $payment_type_id = explode(',',$payment_data_ar[$i])[0];
                    $amount = explode(',',$payment_data_ar[$i])[1];
                    $bank_id = explode(',',$payment_data_ar[$i])[2];
                    $cheque = explode(',',$payment_data_ar[$i])[3];
                    $card = substr((explode(',',$payment_data_ar[$i])[4]), -4);
                    $payment_method_id = explode(',',$payment_data_ar[$i])[5];
                    $card_expiration_date = explode(',',$payment_data_ar[$i])[6];
                    if($payment_type_id == 1)
                        $reference_number ='';
                    else if($payment_type_id == 2 || $payment_type_id == 3)    
                        $reference_number = $card;
                    else if($payment_type_id == 4)
                        $reference_number = $cheque;
                    $payment_data[$i] = [
                        'sale_id'  => $last_inserted_sale_id,
                        'customer_id'  => $customer_id,
                        'amount'  => $amount,
                        'payment_type_id'  => $payment_type_id,
                        'bank_id'  => $bank_id,
                        'payment_method_id'  => $payment_method_id,
                        'card_expiration_date'  => $card_expiration_date,
                        'reference_number'  => $reference_number,
                        'payment_authorized_by_id'  => $all_sale_item_data_arr['payment_authorized_by_id'],
                        'remarks'  => '',
                        'created_at' => date('Y-m-d H:i:s'),
                    ];
                    //insert payment data
                    $payment_data_insert_query = $this->payment->insertData($payment_data[$i]);
                }
            }
        }
        return $this->response->setJSON([
            'error' => false,
            'message' => $last_inserted_sale_id
        ]);
    }
    public function getSpecificVoucherSaleData($sale_id)
    {  
        $dompdf = new Dompdf();
        $sale_item_data = $this->giftCardModel->getSpecificVoucherSaleData($sale_id);
        $sale_data = $this->sale->getSpecificData($sale_id);
        $sale_created_at = $sale_data->created_at;
        $pos_id = $sale_data->pos_id;
        $total_amount = $sale_data->total_amount;
        $discount_amount = $sale_data->discount_amount;
        $customer_name = ($this->common->getSpecificColumnValueByGivenColumnName('customers','id','first_name',($sale_data->customer_id),'delete_flag',0))->first_name;
        $employee_name = ($this->common->getSpecificColumnValueByGivenColumnName('employee','EmpID','EmpName',($sale_data->user_id),'delete_flag',0))->EmpName;
        $data = [
            'imageSrc'    => $this->imageToBase64(ROOTPATH . '/public/img/logo.png'),
            'sale_id'         => $sale_id,
            'customer_name'   => $customer_name,
            'employee_name'   => $employee_name,
            'sale_created_at' => $sale_created_at,
            'pos_id'          => $pos_id,
            'total_amount'    => $total_amount,
            'discount_amount' => $discount_amount,
            'sale_item_data'  => $sale_item_data,
        ];
        $html = view('gift_voucher_sale_invoice_pdf', $data);
        $dompdf->loadHtml($html);
        $dompdf->render();
        $dompdf->stream('gift_voucher_sale_invoice_'.$sale_id.'.pdf',array('Attachment'=>0));
    }

      // gift card disable
      public function disablegiftcard($id = null)
      {
          $data = [
              'current_status' => '2'
          ];
          if($this->giftCardModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
      //gift card enable
      public function enablegiftcard($id = null)
      {
          $data = [
              'current_status' => '1'
          ];
          if($this->giftCardModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }

}
