<?php

namespace App\Controllers;

use App\Controllers\BaseController;

use App\Models\UserModel;
use App\Models\ItemsModel;
use App\Models\SuppliersModel;
use App\Models\ReceivingModel;
use App\Models\ItemCategoryModel;
use App\Models\ReceivingDetailModel;
use App\Models\ReceivingSerialDetailModal;
use App\Models\StocksModel;
use App\Models\ItemUnitsModel;
use App\Models\TempReceivingModel;
use App\Models\PurchasingPriceModel;
use App\Models\ConversionFactorModel;
//use Dompdf\Dompdf;
use TCPDF;


class ReceivingsController extends BaseController
{
    private $ReceivingModel = null;
    private $ItemCategoryModel = null;
    private $ReceivingDetailModel = null;
    private $SuppliersModel = null;
    private $ItemsModel = null;
    private $ReceivingSerialDetailModal = null;
    private $StocksModel = null;
    private $ItemUnitsModel = null;
    private $TempReceivingModel = null;
    private $PurchasingPriceModel = null;
    private $ConversionFactorModel = null;
    private $now = null;

    public function __construct()
    {
        $this->ReceivingModel = new ReceivingModel();
        $this->ItemCategoryModel = new ItemCategoryModel();
        $this->ReceivingDetailModel = new ReceivingDetailModel();
        $this->SuppliersModel = new SuppliersModel();
        $this->ItemsModel = new ItemsModel();
        $this->ReceivingSerialDetailModal = new ReceivingSerialDetailModal();
        $this->StocksModel = new StocksModel();
        $this->ItemUnitsModel = new ItemUnitsModel();
        $this->TempReceivingModel = new TempReceivingModel();
        $this->PurchasingPriceModel = new PurchasingPriceModel();
        $this->ConversionFactorModel = new ConversionFactorModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
    }

    public function index()
    {         
        $user_info = getUserInfo();   
        $items = $this->ItemsModel->getItemActiveIndexData();
        $ItemCategories = $this->ItemCategoryModel->getAllCategories();
        $Suppliers=$this->SuppliersModel->getActiveSupplierIndexData();
        $has_errors = 'false';
        $count = $this->TempReceivingModel->countAll();
          
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Receivings',
            'link' => 'receivings',
            'sources' => $items,
            'Suppliers'=>$Suppliers,
            'ItemCategories'=>$ItemCategories,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
            'count' => $count,
        );
        // echo '<pre>';
        // print_r($data);
        //   die();
        return view('receivings', $data);
    }

    public function saveRecItem()
    {   
        $validation = \Config\Services::validation();
        $request = \Config\Services::request();
        $validation = $validation->withRequest($request);

        $formdata = $this->request->getPost('frmData');
        $tableData = $this->request->getPost('tableData');
        parse_str($formdata, $parseData);

        $Rec = [];
        $RecDetail = [];
        $RecStocks = [];
        $serialInputs = [];
        $RecSerialDetail = [];
        $BNo = $this->checkBatchNo();

        $rules = [
            'SupplierID' => 'required',
            'UserID' => 'required',
            'RNet' => 'required',
            'RNetwithtax' => 'required',
            'RPaymentType' => 'required',
        ];

        if($parseData){
            $Rec = [
                'SupplierID' => $parseData['supplier'],
                'RType'  => $parseData['recMode'],
                'UserID'  => $parseData['userId'],
                'RBatchNo' => $BNo,
                'RComment'  =>$parseData['comments'],
                'RNet'  =>$parseData['subtot'],
                'RNetwithtax'  => $parseData['tot'],
                'RPaymentType'  => $parseData['payType'],
                'RCreatedAt' => $this->now,
                'RStatus'=>'1'
            ];
        }

        //$validation->setRules($rules);
        
        // if($validation->run($Rec)){
        //     return $Rec;
        // }
        
        $Reclast_id = $this->ReceivingModel->insertRecData($Rec);
        
        if($tableData){
            //var_dump($tableData);
            foreach($tableData as $tData){
                //var_dump($tData);
                //check and compare with base units
                $convertedUnit = '';
                $check_items_base_unit = $this->ItemsModel->getItemBaseUnit($tData['itemid']);
                //var_dump($check_items_base_unit);
                //var_dump($check_items_base_unit->ItemUnit);
                //var_dump($tData['unit']);
                if($check_items_base_unit->ItemUnit != $tData['unit']){
                    $covertion_factor = $this->ConversionFactorModel->getConvertionRate($tData['unit'], $check_items_base_unit->ItemUnit);
                    //var_dump($covertion_factor);
                    foreach($covertion_factor as $cfrow){ 
                        //var_dump($cfrow->CFFactor);                       
                        $convertedUnit = (int)$cfrow->CFFactor * $tData['qty'];
                        //var_dump($convertedUnit);
                    }
                }else{
                    //var_dump("Units no need to convert");
                    $convertedUnit = $tData['qty'];
                }
                $i = 0;
                $RecDetail = [
                    'RID' => $Reclast_id,
                    'ItemID' => (int)$tData['itemid'],
                    'RDIsSerialized' => $tData['serialized'],
                    'RDLine' => $i,
                    'RDQty' => $convertedUnit,
                    'RDUnit' => $tData['unit'],
                    'RDCostPrice' => $tData['price'],
                    'RDSellingPrice' => $tData['sellprice'],
                    'RDMFD' => $tData['manDate'],
                    'RDEXP' => $tData['expDate'],
                    'RDiscount' => $tData['disc'],
                    'RAmount' => $tData['ramount'],
                    'RDCreatedAt' => $this->now,
                    'RDStatus'=> '1'
                ];
                $i++;
                $RecStocks = [
                    'ItemID' => (int)$tData['itemid'],
                    'BatchNo' => $BNo,
                    'Unit' => $convertedUnit,
                    'Qty' => $tData['qty'],
                    'Price' => $tData['sellprice'],
                    'MFDate' => $tData['manDate'],
                    'ExpDate' => $tData['expDate'],
                    'StockCreatedAt' => $this->now,
                    'StockStatus' => '1'
                ];
                //var_dump($RecDetail);
                //var_dump($RecStocks);

                $this->StocksModel->insertStockData($RecStocks);
                $last_id = $this->ReceivingDetailModel->saveData($RecDetail);

                //var_dump($tData['serialData']);
                if($tData['serialData'] != '' && $tData['serialized'] == '1'){
                    $serialInputs = json_decode($tData['serialData'], true);
                    //var_dump($serialInputs);
                    foreach ($serialInputs as $serial){
                        //var_dump($serial);
                        $RecSerialDetail['RDID'] = $last_id;
                        $RecSerialDetail['item_id'] = $tData['itemid'];
                        $RecSerialDetail['receiving_id'] = $Reclast_id;
                        $RecSerialDetail['serial_number'] = $serial['serialno'];
                        $RecSerialDetail['item_status'] = $serial['status'];
                        $RecSerialDetail['warranty_period'] = $serial['warrenty'];
                        $RecSerialDetail['is_available_in_stock'] = '1';
                        $RecSerialDetail['created_at'] = $this->now;
                        //var_dump($RecSerialDetail);
                        $finalInsert = $this->ReceivingSerialDetailModal->insertSerialData($RecSerialDetail);
                    }                    
                    //var_dump($RecSerialDetail);
                }

                //insert purchasing price
                $purchasingData = [                    
                    'item_id' => (int)$tData['itemid'],
                    'item_name' => '',
                    'purchasing_price' => $tData['price'],
                    'batch_number' => $BNo,
                    'created_at' => $this->now,
                    'created_by' => $parseData['userId']
                ];

                $this->PurchasingPriceModel->insertData($purchasingData);
            }
        }
        return $this->response->setJSON([
            'error'=>false,
            'message'=>$Reclast_id,
            'title' => 'Success',
            'text' => 'Receiving Stored Successfully',
            'icon' => 'success'
        ]);
    }

    public function singleItemData($id=null)
    {
        $items = $this->ItemsModel->getSingleItemData($id);

        if($items){
            //var_dump($data);\
            $itemUnits = $this->ItemUnitsModel->getSingleItemUnitData($id);
            $itemSerials = $this->ReceivingSerialDetailModal->getSingleData($id);
            //get the last cost price from stocks table
            $last_cost_price = $this->PurchasingPriceModel->getLastCostPrice($id);
            $lCostPrice = '';
            if($last_cost_price != ''){
                $lCostPrice = $last_cost_price;
            }else{
                $lCostPrice = '0.00';
            }
            $data = [
                'items' => $items,
                'itemUnits' => $itemUnits,
                'itemSerials' => $itemSerials,
                'last_cost_price' => $lCostPrice
            ];
            return $this->response->setJSON($data);
        }else{
            echo json_encode(array("status" => false));
        }
    }

    public function delete($id = null)
    {
        $data = [
            'RDeletedAt' => $this->now,
            'RStatus' => '0',
        ];
        // $model->update($id, $data);
        $this->ReceivingModel->deleteitem($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        //return $this->response->redirect(site_url('/banks'));
    }

    //check previous batch no and generate batch no
    public function checkBatchNo()
    {
        $preData = $this->ReceivingModel->checkBatchNo();
        //var_dump($preData);
        // Get the previous batch number from the database
        $previousBatchNumber = $this->ReceivingModel->checkBatchNo(); // example value

        $batchno = null;
        foreach($previousBatchNumber as $pbn):
            $batchno = $pbn['RBatchNo'];
        endforeach;
        // Extract the numeric portion of the previous baton number
        $previousBatchNumberNumeric = (int)substr($batchno, 1);

        // // Increment the numeric portion
        $newBatchNumberNumeric = $previousBatchNumberNumeric + 1;

        // // Format the new baton number
        $newBatchNumber = "B" . sprintf('%04d', $newBatchNumberNumeric);

        return $newBatchNumber;
    }

    public function getSpecificRecData($rec_id)
    {  
        $timestamp = time();
        //$dompdf = new Dompdf();
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $Recdata = $this->ReceivingModel->getSingleRecData($rec_id);
        $RecDetaildata = $this->ReceivingDetailModel->getSingleRecDetailData($rec_id);

        $data = [
            'imageSrc'    => $this->imageToBase64(ROOTPATH . '/public/img/logo.png'),
            'receivings' => $Recdata,
            'receivingdetails' => $RecDetaildata,
            'timestamp' => $timestamp
        ];
        
        $pdf_name = "Receivings_".$timestamp."_".$rec_id.".pdf";
        $html = view('receivings_pdf', $data);
        // // $dompdf->loadHtml($html);
        // // $dompdf->render();
        // // $dompdf->stream($pdf_name,array('Attachment'=>0));
        $pdf->AddPage();
        $pdf->Image("image.png", 200);
        $pdf->writeHTML($html);
        $this->response->setContentType('application/pdf');
        $pdf->output($pdf_name,'I');
    }

    private function imageToBase64($path) {
        $path = $path;
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        return $base64;
    }

    //Receiving search bar
    public function searchItem()
    {
        $searchText = $this->request->getGet('search');
        //var_dump($searchText);
        // Perform the search based on the search text
        $results = $this->ItemsModel->searchItems($searchText);
        
        return $this->response->setJSON($results);
        //return $this->respond($results);
    }
}

