<?php

namespace App\Controllers;
use App\Models\BanksModel;
use App\Models\UserModel;
use App\Controllers\BaseController;

class BanksController extends BaseController
{    
    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->bankModel = new BanksModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
    }

    
    // insert data
    public function insert() {
        $validation = $this->validate([
            'BankName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter Item Name',
                ],
            ],
            'BCardType' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'BRate' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter value',
                ],
                
            ],
            'BStartingDate' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select date',
                ],
                
            ],
            'BEndingDate' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select date',
                ],
            ],

        ]);
        $bID = $this->request->getVar('BID');
        if($validation){
            if($bID == ''){  //insert bank details
        $data = [
            'BankName' => $this->request->getVar('BankName'),
            'BCardType'  => $this->request->getVar('BCardType'),
            'BRate'  => $this->request->getVar('BRate'),
            'BStartingDate'  => $this->request->getVar('BStartingDate'),
            'BEndingDate'  => $this->request->getVar('BEndingDate'),
            'BStatus' => '1',
            'BCreatedat' => date('Y-m-d H:i:s'),
        ];
        $this->bankModel->insertBankData($data);
        }
        else{   //update bank details
            $data = [
                'BankName' => $this->request->getVar('BankName'),
                'BCardType'  => $this->request->getVar('BCardType'),
                'BRate'  => $this->request->getVar('BRate'),
                'BStartingDate'  => $this->request->getVar('BStartingDate'),
                'BEndingDate'  => $this->request->getVar('BEndingDate'),
                'BUpdatedAt'=>date('Y-m-d H:i:s'),
            ];
            $this->bankModel->updateBank($bID, $data);
        }
        return $this->response->redirect(site_url('/banks'));
    }
    else{
        $user_info = getUserInfo();      
        $bms['Banks']=$this->bankModel->getIndexNBankData();
        $has_errors = 'true';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Banks',
            'link' => 'banks',
            'sources' => $bms,
            'userinfo' => $user_info,
            'validation'=>$this->validator,
            'has_errors' => $has_errors,
        );
        return view('banks', $data);
    }
    }
   
    //get single data
    public function singleData($id = null) {
        $data=$this->bankModel->getSingleBankData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    public function index()
    {
        $user_info = getUserInfo();
        $bms['Banks']=$this->bankModel->getIndexNBankData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Banks',
            'link' => 'banks',
            'sources' => $bms,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('banks', $data);
    }
    
    // delete
    public function delete($id = null){
        $BanksModel = new BanksModel();
        $data = [
            'BDeletedAt' =>  $this->now,
            'BStatus' => '0',
        ];
         $BanksModel->deleteBank($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/banks'));
    } 
}
