<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CustomerContactInformationModel;
use App\Models\CustomerModel;

class CustomerContactInformationController extends BaseController
{
    //construct function
    public function __construct(){
        $this->customer_contact_information = new CustomerContactInformationModel();   
        $this->customer = new CustomerModel();          
        helper(['url','form','app']);
    }
    //insert/update data
    public function submit() {
        $validation = $this->validate([
            'customer_id' => [
                'rules'=>'required|greater_than[0]',
                'errors'=>[
                    'required'=>'Please select customer',
                    'greater_than'=>'Please select customer',
                ],
            ],
            'address' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter address',
                ],
            ],
            'phone_number' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter phone number',
                ],
            ],
            'email' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter email',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        if($validation){
            if($id == ''){  
                //insert
                $data = [
                    'customer_id' => $this->request->getVar('customer_id'),
                    'address'  => $this->request->getVar('address'),
                    'phone_number'  => $this->request->getVar('phone_number'),
                    'email'  => $this->request->getVar('email'),
                    'is_default'  => $this->request->getVar('is_default'),
                    'created_at' => date('Y-m-d H:i:s'),
                ];
                $this->customer_contact_information->insertData($data);
            }
            else{   
                //update
                $data = [
                    'customer_id' => $this->request->getVar('customer_id'),
                    'address'  => $this->request->getVar('address'),
                    'phone_number'  => $this->request->getVar('phone_number'),
                    'email'  => $this->request->getVar('email'),
                    'is_default'  => $this->request->getVar('is_default'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
                $this->customer_contact_information->updateData($id, $data);
            }
            return $this->response->redirect(site_url('/customer_contact_information'));
        }
        else{
            $user_info = getUserInfo();
            $records['CustomerContactInformation'] = $this->customer_contact_information->index();
            $has_errors = 'true';
            $customers = $this->customer->index();
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'CustomerContactInformation',
                'link' => 'customer_contact_information',
                'sources' => $records,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                'customers' => $customers,
            );
            return view('/customer_contact_information', $data);
        }
    }
    //get specific data
    public function getSpecificData($id = null) {
        $data=$this->customer_contact_information->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['CustomerContactInformation'] = $this->customer_contact_information->index();
        $has_errors = 'false';
        $customers = $this->customer->index();
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'CustomerContactInformation',
            'link' => 'customer_contact_information',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
            'customers' => $customers,
        );
        return view('customer_contact_information', $data);
    }
    // delete data
    public function delete($id = null){
        $data = [
            'deleted_at' => date("Y-m-d H:i:s"),
            'delete_flag' => 1,
        ];
        $this->customer_contact_information->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
