<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CustomerModel;

class CustomerController extends BaseController
{
    //construct function
    public function __construct(){
        $this->customer = new CustomerModel();         
        helper(['url','form','app']);
    }
    //insert/update data
    public function submit() {
        $validation = $this->validate([
            'first_name' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter customer first name',
                ],
            ],
            'last_name' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter customer last name',
                ],
            ],
            'birthday' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select customer birthday',
                ],
            ],
            'nic' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter customer NIC',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        if($validation){
            if($id == ''){  
                //insert
                $data = [
                    'first_name' => $this->request->getVar('first_name'),
                    'last_name'  => $this->request->getVar('last_name'),
                    'birthday'  => $this->request->getVar('birthday'),
                    'nic'  => $this->request->getVar('nic'),
                    'created_at' => date('Y-m-d H:i:s'),
                ];
                $this->customer->insertData($data);
            }
            else{   
                //update
                $data = [
                    'first_name' => $this->request->getVar('first_name'),
                    'last_name'  => $this->request->getVar('last_name'),
                    'birthday'  => $this->request->getVar('birthday'),
                    'nic'  => $this->request->getVar('nic'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
                $this->customer->updateData($id, $data);
            }
            return $this->response->redirect(site_url('/customer'));
        }
        else{
            $user_info = getUserInfo();      
            $data['Customers']=$this->customer->index();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Customers',
                'link' => 'customer',
                'sources' => $data,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('customer', $data);
        }
    }
    //get specific data
    public function getSpecificData($id = null) {
        $data=$this->customer->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['Customer'] = $this->customer->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Customer',
            'link' => 'customer',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('customer', $data);
    }
    // delete data
    public function delete($id = null){
        $data = [
            'deleted_at' => date("Y-m-d H:i:s"),
            'delete_flag' => 1,
        ];
        $this->customer->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
