<?php

namespace App\Controllers;

use App\Models\ItemBinsModel;
use App\Controllers\BaseController;

class ItemBinsController extends BaseController
{
    private $model = null;
    private $now = null;

    public function __construct()
    {   
        $this->model = new ItemBinsModel();
        $this->now = date("Y-m-d H:i:s");
    }

    public function index()
    {
        $ItemLocationBins['ItemLocationBins'] = $this->model->getAllLocationbins();
        $data = array(
            'ItemLocationBins' => $ItemLocationBins
        );
        return view('/locations', $data);
    }
    
    // insert data
    public function insert() {
        $itembinlocationid = $this->request->getVar('itemBinId');
        if($itembinlocationid == ''){  //Insert Item Location
            $data = [
                'ILID' => $this->request->getVar('itemBinLocationId'),
                'IBName'  =>  $this->request->getVar('itemBinLocatonName'),
                'ItemID'  =>  $this->request->getVar('IBItem'),
                'BatchNo'  => $this->request->getVar('IBBatchNo'),
                'ILQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                'IBStatus' => '1',
                'IBCreaterAt' => $this->now,
            ];
            $this->model->insertLocationBins($data);
        }else{   //Update Item Location
            $data = [
                'IBName' => $this->request->getVar('itemBinLocationId'),
                'IBName'  =>  $this->request->getVar('itemBinLocatonName'),
                'ItemID'  =>  $this->request->getVar('IBItem'),
                'BatchNo'  => $this->request->getVar('IBBatchNo'),
                'IBQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                'IBUpdatedAt' => $this->now,
            ];
            $this->model->updateItemLocationBins($itembinlocationid, $data);
        }
        return $this->response->redirect(site_url('/locations'));
    }
    
    //get single data
    public function singleData($id = null) 
    {        
        $data=$this->model->getSingleLocationBinsData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete
    public function delete($id = null)
    {
        $data = [
            'IBDeletedAt' => $this->now,
            'IBStatus' => '0',
        ];

        $this->model->deleteItemLocationBins($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    }    
}
