<?php

namespace App\Controllers;

use App\Models\ItemCategoryModel;
use App\Models\ItemsCategoryDetailsModel;
// use App\Models\ItemsModel;
// use App\Models\UnitsModel;
use App\Models\UserModel;
use App\Controllers\BaseController;

class ItemCategoryController extends BaseController
{
    private $UserModel = null;
    private $ItemCategoryModel = null;
    private $ItemsCategoryDetailsModel = null;
    // private $ItemsModel = null;
    // private $UnitsModel = null;
    private $now = null;

    public function __construct()
    {   
        $this->UserModel = new UserModel();
        $this->ItemCategoryModel = new ItemCategoryModel();
        $this->ItemsCategoryDetailsModel = new ItemsCategoryDetailsModel();
        // $this->ItemsModel = new ItemsModel();
        // $this->UnitsModel = new UnitsModel();
        $this->now = date("Y-m-d H:i:s");

        helper(['url','form']);
    }

    public function index()
    {
        $ItemCategories['ItemCategories'] = $this->ItemCategoryModel->where('ICStatus', '1')->orderBy('ICID', 'ASC')->findAll();
        
        $loggedUserID = session()->get('loggedUser');
        $user_info = $this->UserModel->getSingleUserData($loggedUserID);

        $data = array(
            'ItemCategories' => $ItemCategories,
            'userinfo' => $user_info
        );
        return view($data);
    }
    
    // insert data
    public function insert()
    {
        // echo  'hi';
        // die();

        // $validation = $this->validate([
        //     'ItemName' => [
        //         'rules'=>'required|is_not_unique[phppos_item.ItemName]',
        //         // 'rules'=>'required',
        //         'errors'=>[
        //             'required'=>'Please Enter Item Name',
        //             'is_not_unique'=>'Item already exisit.',
        //         ],
        //     ],
           
        // ]);

        // if($validation){
        $icid = $this->request->getVar('ICID');
        if($icid == ''){ //Insert Item Category
            $data = [
                'ICName' => $this->request->getVar('ICName'),
                'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                'ICParentID'  => $this->request->getVar('ICParentID'),
                'ICStatus' => '1',
                'ICCreatedAt' => $this->now,
            ];
            $this->ItemCategoryModel->insert($data);
            $lastInsertedCatID = $this->ItemCategoryModel->getInsertID();
            
            $catcheck = $this->ItemCategoryModel->where('ICID', $lastInsertedCatID)->first();
            $parentID = $catcheck['ICParentID'];
            if($parentID == '0'){
                $path = $this->request->getVar('ICName');
            }else{                
                $parentCheck = $this->ItemCategoryModel->where('ICID', $parentID)->first();
                $path = $parentCheck['ICName'];
            }

            if($lastInsertedCatID){
                $catdetailsdata = [
                    'ICID' => $lastInsertedCatID,
                    'ICPath' => $path,
                    'ICLink' => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                    'ICDStatus' => '1',
                ];

                $this->ItemsCategoryDetailsModel->insert($catdetailsdata);
            }

        }else{ //update Item Category
            $data = [
                'ICName' => $this->request->getVar('ICName'),
                'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                'ICParentID'  => $this->request->getVar('ICParentID'),
                'ICUpdatedAt' => $this->now,
            ];

            $catcheck = $this->ItemCategoryModel->where('ICID', $icid)->first();
            $catdetailscheck = $this->ItemsCategoryDetailsModel->where('ICID', $icid)->first();
            $updateparentedid = $this->request->getVar('ICParentID');
            if($updateparentedid == $catcheck['ICParentID']){                
                $catdetailsdata = [
                    'ICLink'=> strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                ];
                
            }else{
                $catcheck = $this->ItemCategoryModel->where('ICID', $updateparentedid)->first();
                $updatepath = $catcheck['ICName'];
                $catdetailsdata = [
                    'ICPath'=> $updatepath,
                    'ICLink'=> strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                ];
                var_dump($catdetailsdata);
            }
            
            $this->ItemCategoryModel->updateItemCatgories($icid, $data);
            $this->ItemsCategoryDetailsModel->updateItemCatgoryDetails($catdetailscheck['ICDID'], $catdetailsdata);
        }
        return $this->response->redirect(site_url('/items'));
    }
    // else{
     
    //     $ItemCategories['ItemCategories'] = $this->ItemCategoryModel->where('ICStatus', '1')->orderBy('ICID', 'ASC')->findAll();
        
    //     $loggedUserID = session()->get('loggedUser');
    //     $user_info = $this->UserModel->getSingleUserData($loggedUserID);
    //     $has_errors = 'true';

    //     $data = [
    //         'ICName' => $this->request->getVar('ICName'),
    //         'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
    //         'ICParentID'  => $this->request->getVar('ICParentID'),
    //         'ICStatus' => '1',
    //         'ICCreatedAt' => $this->now,
    //         'ItemCategories' => $ItemCategories,
    //         'userinfo' => $user_info,
    //         'has_errors' => $has_errors,
    //     ];
       
    // }
    //}

    //get single data
    public function singleData($id = null) 
    {
        $data=$this->ItemCategoryModel->getSingleICData($id);

        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete
    public function delete($id = null)
    {
        $data = [
            'ICDeletedAt' => $this->now,
            'ICStatus' => '0',
        ];
        $this->ItemCategoryModel->deleteCategories($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
