<?php

    namespace App\Controllers;
    
    use App\Models\UserModel;
    use App\Models\ItemsModel;
    use App\Models\ItemCategoryModel;
    use App\Models\UnitsModel;
    use App\Models\StocksModel;

    use App\Controllers\BaseController;

    class ItemsController extends BaseController
    {   
        private $UserModel = null;
        private $UnitsModel = null;
        private $ItemsModel = null;
        private $ItemCategoryModel = null;
        private $StocksModel = null;
        private $now = null;
    
        public function __construct()
        {
            $this->UserModel = new UserModel();
            $this->UnitsModel = new UnitsModel();
            $this->ItemsModel = new ItemsModel();
            $this->ItemCategoryModel = new ItemCategoryModel();
            $this->StocksModel = new StocksModel();
            $this->now = date("Y-m-d H:i:s");

            helper(['url','form','app']);
        }
    
       

        public function getItems()
        {
            $data = $this->ItemsModel->getItemIndexData();
        }

        // public function saveandrec()
        // {           
        //     $model = new ItemsModel();
        //     $data = [
           
        //        'ItemName' => $_POST['ItemName'],
        //        'ItemCategory' => $_POST['ItemCategory'],
        //        'ItemTags' => $_POST['ItemTags'],
        //        'ItemDescription' => $_POST['ItemDescription'],
        //        'ItemUnit' => $_POST['ItemUnit'],
        //        'ItemReorderLevel' => $_POST['ItemReorderLevel'],
        //         //'ItemIsSerialized' =>  $_POST['ItemIsSerialized'],
        //        'ItemStatus' =>  '1',
        //        'ItemCreatedAt' => $this->now,
               
        //     ];

        //     if(isset($_POST['ItemIsSerialized'])){
        //         $data['ItemIsSerialized']=1;
        //     }
        //     else{
        //         $data['ItemIsSerialized']=0;
        //     }   
        //     if(!empty($_FILES['ItemImg']['name'])){                
        //         $imageFile = $this->request->getFile('ItemImg');
        //         $imageFile->move('../public/uploads/itemImg');
        //         $imgDetail =$_FILES['ItemImg'];
        //         $data['ItemImg']= $imgDetail ['name'];
            
        //     }
        //     $this->ItemsModel->insert($data);
        //     $data['ItemID'] = $this->ItemsModel->getInsertID();
        //     if($data){
        //         echo json_encode(array('data' => $data));
        //     }else{
        //         echo json_encode(array("status" => false));
        //     }
        // }

        // item insert
        public function save()
        {
            $validation = $this->validate([
                'ItemName' => [
                   // 'rules'=>'required|is_not_unique[phppos_item.ItemName]',
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please Enter Item Name',
                       // 'is_not_unique'=>'Item already exisit.',
                    ],
                ],
        
                'ItemTags' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter tag name',
                    ],
                ],
                'ItemDescription' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter Item Description',
                    ],
                    
                ],
                'ItemUnit' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please choose the Default Unit',
                    ],
                    
                ],

                'ItemReorderLevel' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter value',
                    ],
                ],

                'ItemCategory' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select  a Category',
                    ],
                ],
            ]);
            $iID = $this->request->getVar('ItemID');
            if($validation){
                if(isset($_POST['ItemIsSerialized'])){
                    $ItemIsSerialized = 1;
                }else{
                    $ItemIsSerialized = 0;
                }
                if($iID == ''){  //insert item details
                $data = [            
                    'ItemName' =>  $this->request->getVar('ItemName'),
                    'ItemCategory' =>$this->request->getVar('ItemCategory'), 
                    'ItemTags' =>$this->request->getVar('ItemTags'), 
                    'ItemDescription' => $this->request->getVar('ItemDescription'), 
                    'ItemUnit' => $this->request->getVar('ItemUnit'),
                    'ItemReorderLevel' => $this->request->getVar('ItemReorderLevel'), 
                    'ItemIsSerialized' =>  $ItemIsSerialized,
                    'ItemStatus' =>  '1',
                    'ItemCreatedAt' => $this->now,                
                ];
                if(!empty($_FILES['ItemImg']['name'])){                
                    $imageFile = $this->request->getFile('ItemImg');
                    $imageFile->move('../public/uploads/itemImg');
                    $imgDetail =$_FILES['ItemImg'];
                    $data['ItemImg']= $imgDetail ['name'];            
                }
              
                 $this->ItemsModel->insertItemData($data);
                 $this->response->redirect(site_url('/items'));                                    
                 }
                    else{  //update item details
                        $data = [
                            'ItemName' => $this->request->getVar('ItemName'),
                            'ItemCategory'  => $this->request->getVar('ItemCategory'),
                            'ItemTags'  => $this->request->getVar('ItemTags'),
                            'ItemDescription'  => $this->request->getVar('ItemDescription'),
                            'ItemUnit'  => $this->request->getVar('ItemUnit'),
                            'ItemReorderLevel'  => $this->request->getVar('ItemReorderLevel'),
                            'ItemIsSerialized' =>  $ItemIsSerialized,
                            'ItemUpdatedAt' => $this->now,    
                        ];
            
                        if(!empty($_FILES['ItemImg']['name'])){ 
                            // unlink("../public/uploads/empImg".$old_img_name);
                            $imageFile = $this->request->getFile('ItemImg');
                            $imageFile->move('../public/uploads/itemImg');
                            $imgDetail =$_FILES['ItemImg'];
                            $data['ItemImg']= $imgDetail ['name'];
                        }
                        $this->ItemsModel->updateItem($iID, $data);
                        $this->response->redirect(site_url('/items'));
                        
                    }
            }else{
                $user_info = getUserInfo();
                $ItemCategories = $this->ItemCategoryModel->getAllCategories();
                $itemData = $this->ItemsModel->getItemIndexData();
                $Units = $this->UnitsModel->getAllUnitsData();
                $has_errors = 'true';
                $data = array(
                    'breadcrumbs' => 'true',
                    'title' => 'Items',
                    'link' => 'items',
                    'sources' => $itemData,
                    'ItemCategories' => $ItemCategories,
                    'Units' => $Units,
                    'userinfo' => $user_info,
                    'validation'=>$this->validator,
                    'has_errors' => $has_errors,
                );
                return view('/items', $data);
            }
        }


        public function index()
        {
            $ItemCategories = $this->ItemCategoryModel->getAllCategories();
            $itemData = $this->ItemsModel->getItemIndexData();
            $Units = $this->UnitsModel->getAllUnitsData();    

            $loggedUserID = session()->get('loggedUser');
            $user_info = $this->UserModel->getSingleUserData($loggedUserID);
            $has_errors = 'false';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Items',
                'link' => 'items',
                'sources' => $itemData,
                'ItemCategories' => $ItemCategories,
                'Units' => $Units,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
            );
            return view('items', $data);
        }

        //get single data
        public function singleData($id = null)
        {
            $data = $this->ItemsModel->getSingleItemData($id);
        
            if($data){
                echo json_encode(array("status" => true, 'icon' => 'Sucess', 'title' => 'Deleted!', 'data' => $data));
            }else{
                echo json_encode(array("status" => false,  'icon' => 'eError', 'title' => 'Oops....!'));
            }
        }

        // delete
        public function delete($id = null)
        {
            $data = [            
                'ItemStatus' => '0',
                'ItemDeletedAt' => $this->now,
            ];

            $checkStocks = $this->StocksModel->checkAllStockData($id);
            
            // if item available or not
            if($checkStocks):
                foreach($checkStocks as $checkStock):
                    //var_dump($checkStock);
                    //var_dump($checkStock['ItemID']);
                endforeach;                

                //if($checkStock['ItemID'] == $id):
                    if($checkStock['Qty'] != '0'):
                        echo json_encode(array("status" => false, "icon" => 'error', "title" => 'Error',  'message' => 'Item stock is remaining. Unable to delete the Item.'));
                    else:
                        $this->ItemsModel->deleteitem($id, $data);
                        echo json_encode(array("status" => true, "icon" => 'success', "title" => 'Success', 'message' => 'Item Deleted Successfully!'));
                    endif;
                //endif;
            else:
                $this->ItemsModel->deleteitem($id, $data);
                echo json_encode(array("status" => true, "icon" => 'success', "title" => 'Success', 'message' => 'Item Deleted Successfully!'));
            endif;
        }

        // item - turn off serilize
        public function offserialize($id = null)
        {
            $data = [
                'ItemIsSerialized' => '0'
            ];

            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }

        // item - turn on serilize
        public function onserialize($id = null)
        {
            $data = [
                'ItemIsSerialized' => '1'
            ];

            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }

        // item disable
        public function disableitem($id = null)
        {
            $data = [
                'ItemStatus' => '2'
            ];

            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }

        // item enable
        public function enableitem($id = null)
        {
            $data = [
                'ItemStatus' => '1'
            ];

            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }
        //get item data by item id
        public function getItemData($id = null){
            $data=$this->ItemsModel->getItemData($id);
            if($data){
                echo json_encode(array("status" => true , 'data' => $data));
            }else{
                echo json_encode(array("status" => false));
            }
        }
    }
?>