<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\UnitsModel;
use App\Models\ConversionFactorModel;
use App\Controllers\BaseController;

class UnitandMeaturesController extends BaseController
{
    private $UserModel = null;
    private $UnitsModel = null;
    private $ConversionFactorModel = null;
    private $now = null;

    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->UnitsModel = new UnitsModel();
        $this->ConversionFactorModel = new ConversionFactorModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
    }


    // ================================================== Units =======================================================//
    //create & update units
    public function addupUnits()
    {
        $validation = $this->validate([
            'UnitName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter Unit Name',
                   
                ],
            ],
            'UnitAbbre' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter Unit Abbreviation',
                   
                ],
            ],
        ]);

        if($validation){
        $unitID = $this->request->getVar('UnitID');
        if($unitID == ''){
            $data = [
                'UnitName' => $this->request->getVar('UnitName'),
                'UnitAbbreviation'  => $this->request->getVar('UnitAbbre'),
                'UnitCreatedAt' => $this->now,
                'UnitStatus' => '1',
            ];
            $this->UnitsModel->insertUnits($data);
        }else{    
            $data = [
                'UnitName' => $this->request->getVar('UnitName'),
                'UnitAbbreviation'  => $this->request->getVar('UnitAbbre'),
                'UnitUpdatedAt' => $this->now,
            ];
            $this->UnitsModel->updateUnits($unitID, $data);
        }
        return $this->response->redirect(site_url('/unitandmeatures'));
        }
    else{

        $user_info = getUserInfo(); 

        $allunits = $this->UnitsModel->getAllUnitsData();
        $allCFs = $this->ConversionFactorModel->getAllCFsData();
        $has_errors = 'true';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Unit & Meatures',
            'link' => 'unitandmeatures',
            'userinfo' => $user_info,
            'allunits' => $allunits,
            'allCFs' => $allCFs,
            'validation'=>$this->validator,
            'has_errors' => $has_errors,
                );
        return view('/unitandmeatures', $data);
        }
    }   
    public function index()
    {        
        helper('app'); 
        
        $user_info = getUserInfo(); 

        $allunits = $this->UnitsModel->getAllUnitsData();
        $allCFs = $this->ConversionFactorModel->getAllCFsData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Unit & Meatures',
            'link' => 'unitandmeatures',
            'userinfo' => $user_info,
            'allunits' => $allunits,
            'allCFs' => $allCFs,
            'has_errors' =>$has_errors,
        );
        return view('unitandmeatures', $data);
    }


    //get single unit
    public function singleUnits($id = null)
    {
        $data = $this->UnitsModel->getSingleUnitData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete units
    public function deleteUnit($id = null){
        $data = [
            'UnitDeletedAt' => $this->now,
            'UnitStatus' => '0',
        ];

        $this->UnitsModel->deleteUnits($id, $data);

        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    }
    
    // ================================================== Units - End =======================================================//


    

}
