<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class UserRole extends Migration
{
    public function up()
    {
        //Create UserRole Table
        $this->forge->addField([
            'URoleID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'URName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],   
            'URCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'URUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'URDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'URStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('URoleID');
        $this->forge->createTable('userrole');
    }

    public function down()
    {
        //Drop UserRole Table
        $this->forge->dropTable('userrole');
    }
}
