<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Itemcategory extends Migration
{
    public function up()
    {
        //Create Item Category Table
        $this->forge->addField([
            'ICID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ICName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICLink' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICParentID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('ICID');
        $this->forge->createTable('itemcategory');
    }

    public function down()
    {
        //Drop Item Category Table
        $this->forge->dropTable('itemcategory');
    }
}
