<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Zone extends Migration
{
    public function up()
    {
        //Create Zone Table
        $this->forge->addField([
            'ZoneID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ZoneName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'WHID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ZoneCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ZoneUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ZoneDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ZoneStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('ZoneID');
        $this->forge->createTable('zone');
    }

    public function down()
    {
        //Drop Zone Table
        $this->forge->dropTable('zone');
    }
}
