<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ItemLocations extends Migration
{
    public function up()
    {
        //Create ItemLocations Table
        $this->forge->addField([
            'ILID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'LocationID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BatchNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ILQtyLevel' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ILCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ILUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ILDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ILStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('ILID');
        $this->forge->createTable('itemlocations');
    }

    public function down()
    {
        //Drop ItemLocations Table
        $this->forge->dropTable('itemlocations');
    }
}
