<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ItemCategoryDetails extends Migration
{
    public function up()
    {
        //Create Item Category Details Table
        $this->forge->addField([
            'ICDID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ICID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICPath' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICLink' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ICDCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICDUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICDDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ICDStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('ICDID');
        $this->forge->createTable('itemcategorydetails');
    }

    public function down()
    {
        //Drop Item Category Details Table
        $this->forge->dropTable('itemcategorydetails');
    }
}
