<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Sales extends Migration
{
    public function up()
    {
         //Create Table
         $this->forge->addField([
            'SaleID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'POSID' => [
                'type' => 'INT',
            ],
            'UserID' => [
                'type' => 'INT',
            ],
            'CusID' => [
                'type' => 'INT',
            ],
            'SaleType' => [
                'type' => 'INT',
                'constraint' => 1,
            ],
            'SaleBankName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SaleCard' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SaleCash' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'SaleGiftCard' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SaleGiftCardID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SaleGross' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'SaleDiscounts' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'SaleNet' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'SaleRef' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SaleCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SaleUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SaleDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SaleStatus' => [
                'type' => 'INT',
                'constraint' => 1,
            ]
        ]);

        $this->forge->addPrimaryKey('SaleID');
        // $this->forge->addForeignKey('POSID', '', '', 'CASCADE', 'CASCADE');
        // $this->forge->addForeignKey('UserID', 'user', 'UserID', 'CASCADE', 'CASCADE');
        // $this->forge->addForeignKey('CusID', 'customers', 'CusId', 'CASCADE', 'CASCADE');
        $this->forge->createTable('sales');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('sales');
    }
}
