<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemBinsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'itembins';
    protected $primaryKey       = 'IBID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['ILID', 'IBName', 'ItemID', 'BatchNo','BatchNo', 'IBCreaterAt', 'IBUpdatedAt', 'IBDeletedAt', 'IBStatus'];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'IBCreaterAt';
    protected $updatedField  = 'IBUpdatedAt';
    protected $deletedField  = 'IBDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all location bins data    
    function getAllLocationbins()
    {
        $data= $this->db
            ->table('itembins')
            ->where('IBStatus', '1')
            ->orderBy('IBID ', 'ASC')
            ->get()
            ->getResultArray();

        return $data;
    }
    
    // save location bins data
    function insertLocationBins($data){    
        return $this->db
            ->table('itembins')
            ->insert($data);
	}

    // get single item location bins data
    function getSingleLocationBinsData($id){

        return $this->db
            ->table('itembins')
            ->where(["IBID" => $id])
            ->get()
                ->getRow();

    }
    
    // update location bins
    function updateItemLocationBins($id,$data){

        return $this->db
            ->table('itembins')
            ->where(["IBID" => $id])
            ->set($data)
            ->update();

    }
    
    // delete location bins
    function deleteItemLocationBins($id,$data){
      
        return $this->db
            ->table('itembins')
            ->where(["IBID" => $id])
            ->set($data)
            ->update();
    }
}
