<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemLocationsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'itemlocations';
    protected $primaryKey       = 'ILID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['LocationID', 'ItemID', 'BatchNo', 'ILQtyLevel', 'ILCreaterAt', 'ILUpdatedAt', 'ILDeletedAt', 'ILStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'ILCreaterAt';
    protected $updatedField  = 'ILUpdatedAt';
    protected $deletedField  = 'ILDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all locations data    
    function getAllLocations()
    {
        $data= $this->db
            ->table('itemlocations')
            ->where('ILStatus', '1')
            ->orderBy('ILID ', 'ASC')
            ->get()
            ->getResultArray();

        return $data;
    }
    
    // save locations data
    function insertLocations($data){    
        return $this->db
            ->table('itemlocations')
            ->insert($data);
	}

    // get single item locations data
    function getSingleLocationData($id){

        return $this->db
            ->table('itemlocations')
            ->where(["ILID" => $id])
            ->get()
                ->getRow();

    }
    
    // update locations
    function updateItemLocations($id,$data){

        return $this->db
            ->table('itemlocations')
            ->where(["ILID" => $id])
            ->set($data)
            ->update();

    }
    
    // delete locations
    function deleteItemLocations($id,$data){
      
        return $this->db
            ->table('itemlocations')
            ->where(["ILID" => $id])
            ->set($data)
            ->update();
    }
}
