<?php

namespace App\Models;

use CodeIgniter\Model;

class ReceivingModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'receiving';
    protected $primaryKey       = 'RID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['RID','RType','SupplierID','UserID','RComment','RAmount','RDiscount','RNet','RPaymentType','RCreatedAt','RUpdatedAt','RDeletedAt','RStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RCreatedAt';
    protected $updatedField  = 'RUpdatedAt';
    protected $deletedField  = 'RDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];


    function getItemIndexData()
    {
        $data= $this->db
        ->table('item')
        ->where('ItemStatus', '1')
        ->orderBy('ItemID ', 'ASC')
        ->get()
        ->getResultArray();

        return $data;
    }

    function insertItemData($data)
    {
        return $this->db
            ->table('item')
            ->insert($data);
    }

    // insert receiving to db
    function insertRecData($data)
    {
        $db = db_connect();
        $builder = $db->table($this->table);

        $builder->insert($data);

        return $db->insertID();       
       
    }

//     // insert rec detail 
//     function insertRecDetailData($finalTabledata)
//     {

// //         echo '<pre>';
// //         print_r($finalTabledata);
// // die();

//         return $this->db
//         ->table('receivingdetails')
//         ->insert($finalTabledata);
       
        
    //}
    // get single item category data
    function getSingleItemData($id)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID " => $id])
            ->get()
            ->getRow();

    }
    
    // update employee
    function updateItem($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();

    }
    // delete item
    function deleteitem($id,$data){
        return $this->db
            ->table('receiving')
            ->where(["RID" => $id])
            ->set($data)
            ->update();

    }
}
