<?php

    namespace App\Models;

    use CodeIgniter\Model;

    class SalesModel extends Model{

        protected $table      = 'sales';
        protected $primaryKey = 'SaleID';

        protected $useAutoIncrement = true;

        protected $returnType     = 'array';
        protected $useSoftDeletes = false;

        protected $allowedFields = ['POSID', 'UserID', 'CusID', 'SaleType', 'SaleBankName', 'SaleCard', 'SaleCash','SaleGiftCard','SaleGiftCardID','SaleGross','SaleDiscounts','SaleNet','SaleRef','SaleCreatedAt','SaleUpdatedAt','SaleDeletedAt','SaleStatus'];
        
        // Dates
        protected $useTimestamps = false;
        protected $dateFormat    = 'datetime';
        protected $createdField  = 'SaleCreatedAt';
        protected $updatedField  = 'SaleUpdatedAt';
        protected $deletedField  = 'SaleDeletedAt';

        // Validation
        protected $validationRules      = [];
        protected $validationMessages   = [];
        protected $skipValidation       = false;
        protected $cleanValidationRules = true;

        // Callbacks
        protected $allowCallbacks = true;
        protected $beforeInsert   = [];
        protected $afterInsert    = [];
        protected $beforeUpdate   = [];
        protected $afterUpdate    = [];
        protected $beforeFind     = [];
        protected $afterFind      = [];
        protected $beforeDelete   = [];
        protected $afterDelete    = [];

        //get specific data
        function getSpecificData($id){
            return $this->db->table('sales')->where(["SaleID" => $id])->get()->getRow();
        }
        // get all data
        function index(){
            $data= $this->db->table('sales')->where('SaleStatus', '1')->orderBy('SaleID ', 'ASC')->get()->getResultArray();
            return $data;
        }
    }

?>