<?php

    namespace App\Models;

    use CodeIgniter\Model;

    class UserModel extends Model{

        protected $table      = 'user';
        protected $primaryKey = 'UserID';

        protected $useAutoIncrement = true;

        protected $returnType     = 'array';
        protected $useSoftDeletes = false;

        protected $allowedFields = ['UserID', 'EmpID', 'UserRole', 'UserName', 'UserPassword', 'UserCreatedAt', 'UserUpdatedAt', 'UserDeletedAt', 'UserStatus'];
        
        // Dates
        protected $useTimestamps = false;
        protected $dateFormat    = 'datetime';
        protected $createdField  = 'UserCreatedAt';
        protected $updatedField  = 'UserUpdatedAt';
        protected $deletedField  = 'UserDeletedAt';

        // Validation
        protected $validationRules      = [];
        protected $validationMessages   = [];
        protected $skipValidation       = false;
        protected $cleanValidationRules = true;

        // Callbacks
        protected $allowCallbacks = true;
        protected $beforeInsert   = [];
        protected $afterInsert    = [];
        protected $beforeUpdate   = [];
        protected $afterUpdate    = [];
        protected $beforeFind     = [];
        protected $afterFind      = [];
        protected $beforeDelete   = [];
        protected $afterDelete    = [];

        // get user data
        public function getUserIndexData(){
            $data= $this->db
                ->table('user')
                ->where('UserStatus', '1')
                ->orderBy('UserID', 'ASC')
                ->get()
                ->getResultArray();
            return $data;
        }

    function insertUserData($datau)
    {
        // echo '<pre>';
        // print_r($userData);
        $userData['UserCreatedAt'] = date('Y-m-d H:i:s');
        return $this->db
                    ->table('user')
                    ->insert($datau);
    }

    
    function getSingleEmpData($id){

        $data= $this->db 
        ->table('user')
        ->where('user.EmpID', $id)
        // ->join('employee', 'user.EmpID = employee.EmpID','left outer')
        ->get()
        ->getRow();
        return $data;
       
    }
    
         
        // public function login($username, $password)
        // {
        //     // Get the user data from the database
        //     $user = $this->where('UserName', $username)->first();
        // function insertUserData($userData)
        // {            
        //     $userData['UserCreatedAt'] = date('Y-m-d H:i:s');
        //     return $this->db
        //                 ->table('user')
        //                 ->insert($userData);
        // }
        // function insertUserData($userData)
        // {            
        //     $userData['UserCreatedAt'] = date('Y-m-d H:i:s');
        //     return $this->db
        //         ->table('user')
        //         ->insert($userData);
        // }

        public function check($username, $password)
        {
            // Get the user data from the database
            $user = $this->where('UserName', $username)->first();

            // Check if the user exists
            if ($user) {
                // Verify the password
                if ($user['UserPassword'] === $password) {
                    return $user;
                }
            }
            return false;
        }

        // get single user data
        // function getSingleUserData($id){
        //     return $this->db
        //         ->table('user')
        //         // ->join('employee', 'employee.EmpID= user.EmpID')
        //         ->where(["user.EmpID" , $id])
        //         ->join('employee','employee.EmpID = user.EmpID')
        //         ->where(["UserID" => $id])
        //         ->get()
        //         ->getRow();
               
        // }

        
        // get single user data
        function getSingleUserData($id){

            //print_r($id);
            // die();
            return $this->db
                ->table('user')
                // ->join('employee','employee.EmpID = user.EmpID')
                ->where(["UserID" => $id])
                ->get()
                ->getRow();
        }


        
        
        function getUserEmployeeJoinData($id){
         return $this->db
                ->table('user')
                
                ->where(["user.EmpID", $id])
                ->join('employee', 'employee.EmpID= user.EmpID')
                ->get()
                ->getRow();             
        }

            // get  user data when update employee
            function updateUser($id,$datau){     
                return $this->db
                    ->table('user')
                    ->where(['EmpID'=> $id])
                    ->set($datau)
                    ->update();   
                   
            }


    // delete employee
    function deleteUser($id,$datau){
        // die();
        return $this->db
        ->table('user')
        ->where(["EmpID" => $id])
        ->set($datau)
        ->update();

    }
        
    }

?>